
import sys, pandas as pd, matplotlib.pyplot as plt
if len(sys.argv)!=4: print("Usage: plot_unsupported.py BASE.csv PRG.csv OUT.pdf"); sys.exit(1)
b,p,o=sys.argv[1:4]; db=pd.read_csv(b); dp=pd.read_csv(p)
plt.figure()
plt.plot(db["coverage"], 1.0-db["SCR"], marker="o", label="Baseline")
plt.plot(dp["coverage"], 1.0-dp["SCR"], marker="o", label="PragAURA (per-act)")
plt.xlabel("Coverage (1 – abstain)"); plt.ylabel("Unsupported rate (1 – SCR)")
plt.xlim(0,1); plt.ylim(0,1); plt.legend(frameon=False, loc="lower left"); plt.tight_layout()
plt.savefig(o, bbox_inches="tight"); print("Wrote", o)
