# DELT

You can refer to the example scripts in `scripts` for different settings

# Dataset
All datasets must be compatible with `ImageFolder` from Torchvision

# Initialization-Selection



To select images to be used as initialization, 
1. If the dataset is not ImageNet-1K, download the pretrained teacher model to `/workspace/save/model.pth`
2. use this code to select IPC 50

```bash
TRAIN_DIR="/path/to/train"
OUTPUT_DIR="/path/to/selected/images"
RANKER_PATH="/path/to/pretrained/teacher.pth"

# example for tinyimagenet -> tinyimagenet_resnet18_modified.pth
# curl "https://drive.usercontent.google.com/download?id={1h_Enp0_FlgxCED-oriPuyYbmonYwxIi9}&confirm=xxx" -o "/workspace/save/tinyimagenet_resnet18_modified.pth"

python data_selection.py \
    --dataset "tiny-imagenet" \
    --data-path "$TRAIN_DIR" \
    --output-path "$OUTPUT_DIR" \
    --ranker-path "$RANKER_PATH" \
    --store-rank-file \
    --ranker-arch "resnet18" \
    --ranking-file "/workspace/data/rankings/tiny_imagenet.csv" \
    --selection-criteria "medium" \
    --ipc 50 \
    --gpu-device 1

```

# Recover

do not use `arch-path` if the dataset is `imagenet-1k` and the teacher is `resnet18`

```bash
GPU=0

# =========================================================================================

SYN_PATH="/workspace/data/initialization/conv_imagenet_1k/"
INIT_PATH="/workspace/data/ranked/medium_prob"          # path of selected images of IPC
IPC=50
ITR=4000
ROUND_ITR=500
EXP_NAME="IPC$((IPC))_4K_500_medium"

echo "$EXP_NAME"

python /workspace/DELT/recover/recover.py \
    --init-data-path "$INIT_PATH" \
    --syn-data-path "$SYN_PATH" \
    --arch-name "conv4" \
    --arch-path "/workspace/save/imagenet-1k_conv4.pth" \
    --dataset "imagenet-1k" \
    --exp-name "$EXP_NAME" \
    --use-incremental-learn \
    --skip-per-itr $((ROUND_ITR)) \
    --batch-size 100 \
    --lr 0.25 \
    --r-bn 0.01 \
    --gpu-device $((GPU)) \
    --iteration $((ITR)) \
    --jitter 0\
    --easy2hard-mode "cosine" --milestone 1 \
    --ipc $((IPC)) --store-best-images

echo "Synthesis -> DONE"

```

# Validation

```bash
GPU=0

# =========================================================================================

SYN_PATH="/workspace/data/initialization/imagenet_1k_conv/"
PROJECT_NAME="Imagenet1K-Seeds"
IPC=50
EXP_NAME="IPC$((IPC))_4K_500_medium"
WANDB_API_KEY="write your api here"

echo "$EXP_NAME"
SEED=4663

RAND_AUG="rand-m6-n2-mstd1.0"
# VAL_NAME="$RAND_AUG"
VAL_NAME="IPC$((IPC)) 4K_500 Medium Conv4 S$((SEED))"

wandb enabled
wandb online
python /workspace/DELT/evaluation/main.py \
    --wandb-project "$PROJECT_NAME" \
    --wandb-api-key "$WANDB_API_KEY" \
    --val-dir "/workspace/data/val" \
    --syn-data-path "$SYN_PATH$EXP_NAME" \
    --exp-name "$VAL_NAME" \
    --subset "imagenet-1k" \
    --arch-name "conv4" \
    --use-rand-augment \
    --rand-augment-config "$RAND_AUG" \
    --random-erasing-p 0.0 \
    --factor 2 \
    --num-crop 5 \
    --min-scale-crops 0.25 \
    --max-scale-crops 1.0 \
    --mipc 300 \
    --ipc $((IPC)) \
    --val-ipc 50 \
    --stud-name "conv4" \
    --re-epochs 300 \
    --validate \
    --gpu-device $((GPU)) \
    --seed $((SEED))

# =========================================================================================
```
