# Code for Decooupled Q-Chunking 

Installation: `pip install -r requirements.txt`

Example scripts for `humanoidmaze-giant`:

```bash
# DQC
MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --eval_interval=250000 --online_steps=0 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"

# QC
MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --eval_interval=250000 --online_steps=0 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False

# NS
MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --eval_interval=250000 --online_steps=0 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False

# OS
MUJOCO_GL=egl python main.py --run_group=reproduce --offline_steps=1000000 --eval_interval=250000 --online_steps=0 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False
```

## How do I obtain the 100M, 1B datasets?
Please visit the official OGBench repository for information on how to generate these large datasets.
