#!/bin/bash

TASK_ID=$((SLURM_ARRAY_TASK_ID-1))
PARALLEL_N=1
JOB_N=2

COM_ID_S=$((TASK_ID * PARALLEL_N + 1))

declare -a commands=(
  [1]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimum --offline_steps=1000000 --eval_interval=250000 --online_steps=0 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [2]='MUJOCO_GL=egl python main.py --run_group=reproduce-minimum --offline_steps=1000000 --eval_interval=250000 --online_steps=0 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
)

parallel --delay 20 --linebuffer -j 1 {1} ::: "${commands[@]:$COM_ID_S:$PARALLEL_N}"
        