#!/bin/bash

TASK_ID=$((SLURM_ARRAY_TASK_ID-1))
PARALLEL_N=1
JOB_N=180

COM_ID_S=$((TASK_ID * PARALLEL_N + 1))

declare -a commands=(
  [1]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [2]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [3]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [4]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [5]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [6]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [7]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [8]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [9]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [10]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [11]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [12]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [13]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [14]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [15]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [16]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [17]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [18]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [19]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [20]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [21]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [22]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [23]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [24]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [25]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [26]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [27]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [28]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [29]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [30]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [31]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [32]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [33]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [34]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [35]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [36]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [37]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [38]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [39]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [40]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [41]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [42]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [43]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [44]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [45]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=1 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [46]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [47]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [48]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [49]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [50]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [51]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [52]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [53]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [54]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [55]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [56]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [57]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [58]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [59]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [60]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [61]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [62]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [63]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [64]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [65]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [66]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [67]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [68]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [69]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [70]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [71]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [72]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [73]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [74]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [75]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [76]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [77]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [78]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [79]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [80]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [81]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [82]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [83]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [84]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [85]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [86]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [87]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [88]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [89]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [90]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=2 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [91]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [92]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [93]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [94]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [95]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [96]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [97]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [98]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [99]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [100]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [101]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [102]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [103]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [104]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [105]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [106]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [107]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [108]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [109]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [110]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [111]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [112]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [113]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [114]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [115]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [116]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [117]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [118]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [119]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [120]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [121]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [122]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [123]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [124]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [125]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [126]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [127]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [128]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [129]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [130]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [131]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [132]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [133]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [134]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [135]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=3 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [136]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [137]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [138]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [139]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [140]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [141]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [142]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [143]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [144]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-triple-play-oraclerep-v0cube-quadruple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-triple-play-100m-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [145]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [146]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [147]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [148]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [149]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [150]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [151]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.8 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [152]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [153]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=cube-octuple-play-oraclerep-v0 --agent.q_agg=min --dataset_dir=[my_data_root]/cube-octuple-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [154]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [155]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [156]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [157]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [158]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [159]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [160]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [161]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [162]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=humanoidmaze-giant-navigate-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [163]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [164]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [165]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [166]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [167]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [168]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [169]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [170]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [171]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x5-play-oraclerep-v0 --agent.q_agg=mean --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
  [172]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=1 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="OS" --agent.use_chunk_critic=False'
  [173]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=5,ha=1"'
  [174]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=5" --agent.use_chunk_critic=False'
  [175]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=5 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=5" --agent.use_chunk_critic=False'
  [176]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=1"'
  [177]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=1 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="NS,n=25" --agent.use_chunk_critic=False'
  [178]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="DQC,h=25,ha=5"'
  [179]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=5 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC-NS,n=25,ha=5" --agent.use_chunk_critic=False'
  [180]='MUJOCO_GL=egl python main.py --run_group=reproduce_debug --offline_steps=100 --eval_episodes=0 --video_episodes=0 --eval_interval=20 --log_interval=10 --dataset_replace_interval=10 --seed=4 --agent=agents/dqc.py --agent.num_qs=2 --agent.policy_chunk_size=25 --agent.backup_horizon=25 --agent.distill_method=expectile --agent.distill_tau=0.5 --env_name=puzzle-4x6-play-oraclerep-v0 --agent.q_agg=mean --dataset_dir=[my_data_root]/puzzle-4x6-play-1b-v0 --agent.batch_size=8 --agent.implicit_backup_type=quantile --agent.backup_tau=0.9 --tags="QC,ha=25" --agent.use_chunk_critic=False'
)

parallel --delay 20 --linebuffer -j 1 {1} ::: "${commands[@]:$COM_ID_S:$PARALLEL_N}"
        