def prompt_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me split a medical diagnostic conclusion report into sentences. Please split the sentences where necessary and process the text according to the following rules:

Remove redundant periods, such as '. .'. For example:
Input: feedingtube has been removed. nasogastric tube is coiled in the stomach region. . interval decrease in the right-sided. stable appearance of the left lung.
Output: ['feedingtube has been removed.', 'nasogastric tube is coiled in the stomach region.', 'interval decrease in the right-sided.', 'stable appearance of the left lung.']

For ordered structures like '1.', '2.', keep the ordered structure and the sentence that follows together without splitting. For example:
Input: 1. low lung volumes and mild pulmonary vascular congestion is unchanged. 2. new small right fissural pleural effusion .
Output: ['1. low lung volumes and mild pulmonary vascular congestion is unchanged.', '2. new small right fissural pleural effusion.']

Remove information unrelated to the case, such as treatment recommendations or notifications to relevant personnel. For example:
Input: recommend chest ct with intravenous contrast for further assessment. dr. communicated the above results to dr. at 8:55 am on by telephone. findings were relayed to dr.
Output: (remove these parts)

Remove short sentences that do not contain case information, such as comparisons to previous case results, and any symptoms were not mentioned. For example:
Input: no other relevant change. otherwise little change. comparison is made to prior study from at 4:05 a.m. ap chest compared to and 5:05 p.m.
Output: (remove these parts)

After processing the text, split the remaining information into appropriate sentences and store each sentence in a list.

Example 1:
Input:
recommend chest ct with intravenous contrast for further assessment.dr. communicated the above results to dr. at 8:55 am on by telephone.findings were relayed to dr. 1. low lung volumes and mild pulmonary vascular congestion is unchanged. 2. new small right fissural pleural effusion. no other relevant change. otherwise little change. comparison is made to prior study from at 4:05 a.m. ap chest compared to and 5:05 p.m.
Output:
['1. low lung volumes and mild pulmonary vascular congestion is unchanged.', '2. new small right fissural pleural effusion.']

Example 2:
Input:
right upper lobe pneumonia or mass . however given right hilar fullness a mass resulting in post-obstructive pneumonia is within the differential. recommend chest ct with intravenous contrast for further assessment.dr. communicated the above results to dr. at 8:55 am on by telephone.
Output:
['right upper lobe pneumonia or mass .', 'however given right hilar fullness a mass resulting in post-obstructive pneumonia is within the differential.']

Now, please process the input text according to these rules and store each sentence in a list. Notice: you only need to output the list, do not output any reason!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages

def prompt_1_data(sent):
    prompt = """
Assume you are an experienced radiologist. Please help me process the following medical diagnostic report sentences, adhering to the following requirements:

1.Rewriting Requirement: If the sentence content is related to specific medical parts or symptoms, please rewrite the sentence to ensure:
    (1)Semantic Clarity: The meaning of the sentence is clear and unambiguous.
    (2)Avoid Complex Negative Sentences: The structure of negative sentences is simplified to avoid confusion.
    (3)Avoid Double Negations: Double negatives are not used, as they can complicate understanding.
    (4)Use Active Voice: The active voice is employed whenever possible to enhance directness and clarity.
    (5)Avoid Inversion: Inverted sentence structures are not used to prevent complexity in understanding, rewrite format:'No xxx is present/show' to format:'The patient shows no signs of xxx'.
    (6)Accuracy of Professional Terminology: Precise and consistent medical terminology is used to maintain accuracy.
2.Marking Requirement: If the sentence content is unrelated to any specific medical parts or symptoms, such as when mentioning comparisons or general descriptions (e.g., "Compared to chest radiographs since the most recent one"), please output the letter "X" to mark this situation.

Examples:

Input: The patient exhibits signs of acute appendicitis with localized tenderness in the lower right quadrant.
Output: The patient shows symptoms of acute appendicitis, with localized tenderness observed in the lower right abdominal quadrant.

Input: No consolidation or bone fracture is present.
Output: The patient shows no signs of consolidation or bone fracture.

Input: No acute cardio pulmonary process.
Output: The patient shows no signs of acute cardiac or pulmonary issues.

Input: Compared to chest radiographs since the most recent one, there are no significant changes noted.
Output: X

Please process the input medical diagnostic report sentences according to the above prompt.
Notice: you only need to output the rewrite sentence or "X" , do not output any other thing!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages
def prompt_2_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me identify the correct medical condition label for the given radiology report sentence. Below are the medical condition labels with corresponding numbers and its medical description:

1.Atelectasis: Lung tissue exhibits signs of partial or complete atelectasis, with decreased lung volume and increased localized radiographic density.
2.Pleural Effusion: There is an abnormal accumulation of fluid within the pleural cavity, which is evident on X-ray imaging as a blunted costophrenic angle or the presence of a fluid level.
3.Pneumothorax: There is evidence of free air within the thoracic cavity, resulting in partial or complete atelectasis. This is characterized by a retracted lung edge and an area devoid of lung markings.
4.Cardiomegaly: The cardiac silhouette is enlarged, indicating a size beyond the normal range.
5.Lung Opacity: A lung region demonstrates increased radiopacity, potentially suggestive of inflammatory changes, a tumor, or hemorrhage.
6.Pneumonia: Patchy to diffuse lung infiltrates are observed, frequently associated with air bronchograms.
7.Pulmonary Mass: A lung mass, either well-circumscribed or poorly defined, is present, typically measuring over 3 cm in diameter.
8.Edema: Interstitial or alveolar fluid accumulation in the lungs is evident, characterized by increased and indistinct lung markings, a common finding in cardiogenic pulmonary edema.
9.Lung Nodule: A round or oval opacity within the lung, measuring less than 3 cm in diameter.
10.Lung Infiltration: Patchy or reticular opacities are noted within the lung tissue, suggestive of inflammatory processes or other infiltrative conditions.
11.Pulmonary Fibrosis: Interstitial lung thickening and fibrosis are present, exhibiting a reticular pattern and a honeycomb-like appearance on imaging studies.
12.Pulmonary Emphysema: Overinflation of the lungs with alveolar destruction is observed, manifesting as increased lung lucency and expanded lung fields on the chest X-ray.
13.Pleural Thickening: Pleural layer thickening is evident, appearing as broadened pleural shadows on imaging, often attributed to chronic inflammation or fibrosis.
14.Hernia: Internal organ protrusion through either normal or abnormal openings is observed; in the case of a diaphragmatic hernia, this may present as an abnormal position and contour of the diaphragm on X-ray imaging.
15.Pulmonary Consolidation: The lung alveoli are opacified with fluid or solid material, manifesting as regions of increased density with indistinct borders on imaging.
16.Bone Fracture: A discontinuity within the bone structure is observed on X-ray, characterized by a disrupted cortical bone and the presence of fracture lines.
17.Consolidation: Similar to pulmonary consolidation, the lung tissue exhibits a solidified appearance, a common finding in cases of pneumonia.
18.Enlarged Cardiomediastinum: An enlargement of the mediastinal shadow is noted, which may indicate the presence of mediastinal tumors, hematoma, or other mediastinal abnormalities.
19.Pleural Other: Other pleural abnormalities, such as pleural calcifications or plaques, are present, exhibiting specific imaging features that are indicative of the underlying condition.
20.Lung Lesion: An encompassing term for a variety of abnormal imaging findings within the lung, encompassing nodules, masses, infiltrates, and other anomalies.
21.Support Devices: Visualized on imaging are various medical devices, including catheters, stents, prosthetic heart valves, and other implanted or inserted medical apparatus.
22.Abnormal Lesion: A non-specific term denoting any abnormal imaging findings within the lungs, which may encompass a range of presentations such as nodules, masses, opacities, or other anomalies.
23.Lung Granuloma: A small pulmonary nodule, usually measuring less than 3 cm in diameter, frequently exhibiting calcification.
24.Calcified Granuloma: A calcified granuloma is observed, manifesting as a high-density nodule on imaging studies.
25.Tissue Calcification: Calcifications within soft tissue are noted, appearing as areas of increased density on imaging, indicative of calcified spots or plaques.
26.No Finding: The specified anatomical areas appear normal, and the reported symptoms are negative or absent.

Examples:

Sentence: there is no focal consolidation pleural effusion or pneumothorax.
Label: 26

Sentence: the cardiac mediastinal and hilar contours are normal.
Label: 26

Sentence: bilateral nodular opacities that most likely represent nipple shadows.
Label: 9

Sentence: the cardiomediastinal silhouette is normal.
Label: 26

Sentence: chronic deformity of the posterior left sixth and seventh ribs are noted.
Label: 16

Sentence: The patient shows no signs of free air below the right hemidiaphragm.
Label: 26

Special Note:
If the sentence describes normal anatomical regions or uses phrases like "no," "not present," "negative" or start with "The patient shows no signs of" for symptoms, the label should be "No Finding" (26).
If the sentence describes a specific abnormality or lesion, use the appropriate label.

In case you forgot, let me repeat these labels:
1. Atelectasis
2. Pleural Effusion
3. Pneumothorax
4. Cardiomegaly
5. Lung Opacity
6. Pneumonia
7. Pulmonary Mass
8. Edema
9. Lung Nodule
10. Lung Infiltration
11. Pulmonary Fibrosis
12. Pulmonary Emphysema
13. Pleural Thickening
14. Hernia
15. Pulmonary Consolidation
16. Bone Fracture
17. Consolidation
18. Enlarged Cardiomediastinum
19. Pleural Other
20. Lung Lesion
21. Support Devices
22. Abnormal Lesion
23. Lung Granuloma
24. Calcified Granuloma
25. Tissue Calcification
26. No Finding

Now, please select the most appropriate label for the following sentence and output only the corresponding number. 
Notice: you only need to output label(pure numbers), do not output any other thing!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages

def prompt_3_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me determine whether the patient has Cardiomegaly symptoms. Below are the output labels and its medical description:

4.Cardiomegaly: The cardiac silhouette is enlarged, indicating a size beyond the normal range.
26.No Finding: The specified anatomical areas appear normal, and the reported symptoms are negative or absent.

Examples:

Sentence: The patient's heart size is normal.
Label: 26

Sentence: The patient's heart is top-normal size improved.
Label: 26

Sentence: The patient's cardiomegaly is likely exaggerated due to low lung volumes and patient positioning.
Label: 4

Sentence: The patient's heart size is slightly enlarged.
Label: 4

Sentence: The patient exhibits moderate cardiomegaly.
Label: 4

Special Note:
If the sentence describes heart like "normal" or "The patient shows no signs of cardiomegaly", the label should be "No Finding" (26).
If the sentence describes cardiomegaly, the label should be "Cardiomegaly" (4).

In case you forgot, let me repeat these labels:
4.Cardiomegaly
26.No Finding

Now, please select the most appropriate label for the following sentence and output only the corresponding number. 
Notice: you only need to output label(pure numbers), do not output any other thing!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages

def prompt_2_pro_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me identify the correct medical condition label for the given radiology report sentence. Below are the medical condition labels with corresponding numbers and their medical descriptions:

1.Atelectasis: Lung tissue exhibits signs of partial or complete atelectasis, with decreased lung volume and increased localized radiographic density.
2.Pleural Effusion: There is an abnormal accumulation of fluid within the pleural cavity, which is evident on X-ray imaging as a blunted costophrenic angle or the presence of a fluid level.
3.Pneumothorax: There is evidence of free air within the thoracic cavity, resulting in partial or complete atelectasis. This is characterized by a retracted lung edge and an area devoid of lung markings.
4.Cardiomegaly: The cardiac silhouette is enlarged, indicating a size beyond the normal range.
5.Opacity: A lung region demonstrates increased radiopacity, potentially suggestive of inflammatory changes, a tumor, or hemorrhage.
6.Pneumonia: Patchy to diffuse lung infiltrates are observed, frequently associated with air bronchograms.
7.Pulmonary Mass: A lung mass, either well-circumscribed or poorly defined, is present, typically measuring over 3 cm in diameter.
8.Edema: Interstitial or alveolar fluid accumulation in the lungs is evident, characterized by increased and indistinct lung markings, a common finding in cardiogenic pulmonary edema.
9.Lung Nodule: A round or oval opacity within the lung, measuring less than 3 cm in diameter.
10.Lung Infiltration: Patchy or reticular opacities are noted within the lung tissue, suggestive of inflammatory processes or other infiltrative conditions.
11.Fibrosis: Interstitial lung thickening and fibrosis are present, exhibiting a reticular pattern and a honeycomb-like appearance on imaging studies.
12.Emphysema: Overinflation of the lungs with alveolar destruction is observed, manifesting as increased lung lucency and expanded lung fields on the chest X-ray.
13.Pleural Thickening: Pleural layer thickening is evident, appearing as broadened pleural shadows on imaging, often attributed to chronic inflammation or fibrosis.
14.Hernia: Internal organ protrusion through either normal or abnormal openings is observed; in the case of a diaphragmatic hernia, this may present as an abnormal position and contour of the diaphragm on X-ray imaging.
15.Consolidation: The lung alveoli are opacified with fluid or solid material, manifesting as regions of increased density with indistinct borders on imaging. the lung tissue exhibits a solidified appearance, a common finding in cases of pneumonia.
16.Bone Fracture: A discontinuity within the bone structure is observed on X-ray, characterized by a disrupted cortical bone and the presence of fracture lines.
17.Enlarged Cardiomediastinum: An enlargement of the mediastinal shadow or cardiomediastinal silhouette is noted.
18.Pleural Other: Other pleural abnormalities, such as pleural calcifications or plaques, are present, exhibiting specific imaging features that are indicative of the underlying condition.
19.Lung Lesion: An encompassing term for a variety of abnormal imaging findings within the lung, encompassing nodules, masses, infiltrates, and other anomalies.
20.Support Devices: Visualized on imaging are various medical devices, including catheters, stents, prosthetic heart valves, and other implanted or inserted medical apparatus.
21.Abnormal Lesion: A non-specific term denoting any abnormal imaging findings within the lungs, which may encompass a range of presentations such as nodules, masses, opacities, or other anomalies.
22.Lung Granuloma: A small pulmonary nodule, usually measuring less than 3 cm in diameter, frequently exhibiting calcification.
23.Calcified Granuloma: A calcified granuloma is observed, manifesting as a high-density nodule on imaging studies.
24.Tissue Calcification: Calcifications within soft tissue are noted, appearing as areas of increased density on imaging, indicative of calcified spots or plaques.
25.No Mention: None of the above symptoms are mentioned or related, cannot exist with any other labels at the same time.

Examples:

Sentence: there is no focal consolidation pleural effusion or pneumothorax.
Label: 15, 2, 3

Sentence: bilateral nodular opacities that most likely represent nipple shadows.
Label: 9

Sentence: chronic deformity of the posterior left sixth and seventh ribs are noted.
Label: 16

Sentence: the patient shows no signs of free air below the right hemidiaphragm.
Label: 3

Sentence: the imaged upper abdomen shows no remarkable findings.
Label: 25

Sentence: the patient's overall condition is normal.
Label: 25

Special Note:
If the sentence mentions a condition (whether positive or negative), use the corresponding label.
If the sentence describes multiple conditions, except 25(No Mention), output multiple labels, separated by commas ",".
Remember, 25(No Mention) and other labels cannot exist at the same time.

In case you forgot, let me repeat these labels:
1. Atelectasis
2. Pleural Effusion
3. Pneumothorax
4. Cardiomegaly
5. Opacity
6. Pneumonia
7. Pulmonary Mass
8. Edema
9. Lung Nodule
10. Lung Infiltration
11. Fibrosis
12. Emphysema
13. Pleural Thickening
14. Hernia
15. Consolidation
16. Bone Fracture
17. Enlarged Cardiomediastinum
18. Pleural Other
19. Lung Lesion
20. Support Devices
21. Abnormal Lesion
22. Lung Granuloma
23. Calcified Granuloma
24. Tissue Calcification
25. No Mention

Now, please select the most appropriate label for the following sentence and output only the corresponding number(s).
Notice: you only need to output the label (pure numbers), do not output anything else!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages

def prompt_5_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me identify whether the given radiology report sentence describes "Cardiomegaly" or "Enlarged Cardiomediastinum."
Use the following labels for classification:

4.Cardiomegaly: The cardiac silhouette is enlarged, indicating an increased heart size beyond the normal range. This is specifically identified by an increased cardiothoracic ratio on imaging.
17.Enlarged Cardiomediastinum: An enlargement of the mediastinal shadow or cardiomediastinal silhouette is noted, which may include enlarged mediastinal or hilar contours. This can indicate the presence of mediastinal tumors, hematoma, or other abnormalities within the mediastinum or involving the heart and surrounding structures.

Examples:

Input: The cardiac silhouette is enlarged, indicating cardiomegaly.
Output: 4

Input: There is enlargement of the mediastinal shadow.
Output: 17

Input: The mediastinum appears widened on the X-ray.
Output: 17

Input: No evidence of cardiomegaly is observed.
Output: 4

Now, please select the most appropriate label for the following sentence.
Notice: output only the corresponding number ("4" or "17").
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages

def prompt_4_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me identify whether the given radiology report sentence contains specific diagnostic information.

If the sentence mention the patient's designated site: bony structures or bone fracture, output "17".
else, output "25".

Examples:

Sentence: The patient's cardiomediastinal silhouette appears normal.
Label: 17

Sentence: The patient exhibits persistent thoracic kyphosis, with mild wedging observed in a mid-thoracic vertebral body.
Label: 25

Now, please select the most appropriate label for the following sentence and output only the corresponding number. 
Notice: you only need to output label(pure numbers), do not output any other thing!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages

def prompt_3_plus_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me determine whether the patient has Cardiomegaly symptoms. Below are the medical condition labels with their descriptions:

16: mention the patient's designated site: bony structures or bone fracture.
17: mention the patient's designated site: mediastinal shadow or mediastinal outline or mediastinal or hilar outline.
25: the patient looks like normal.
26: there is other symptoms present, such as vascular congestion, thoracic kyphosis, aorta tortuous and so on.

Examples:

Sentence: The patient's bony structures appear normal.
Label: 16

Sentence: The mediastinal and hilar contours appear normal.
Label: 17

Sentence: The patient's pulmonary vascular congestion is stable and mild.
Label: 26

Sentence: The patient exhibits persistent thoracic kyphosis, with mild wedging observed in a mid-thoracic vertebral body.
Label: 26

Sentence: The patient shows mild vascular engorgement.
Label: 26

Sentence: The patient had no acute intrathoracic symptoms.
Label: 25

Sentence: The aorta is tortuous.
Label: 26

Sentence: The aorta shows slight tortuosity.
Label: 26

Special Note:
If the sentence does not mention neither [bony structures, bone fracture] or [mediastinal shadow, mediastinal outline, mediastinal, hilar outline], while the patient is not healthy and present some symptoms, choose 26.

In case you forgot, let me repeat these labels:
16: mention the patient's designated site: bony structures or bone fracture.
17: mention the patient's designated site: mediastinal shadow or mediastinal outline or mediastinal or hilar outline.
25: the patient looks like normal.
26: there is other symptoms present.

Now, please select the most appropriate label for the following sentence and output only the corresponding number. 
Notice: you only need to output label(pure numbers), do not output any other thing!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages

def prompt_3_pro_data(sent):
    prompt = """
Assume you are an experienced radiologist. Help me identify whether the given radiology report sentence contains diagnostic information.
If the sentence contains diagnostic information related to a medical condition, output "25".
If the sentence does not contain any diagnostic information, output "X".

Examples:

Sentence: The patient would need to be repositioned, with the tube pulled back approximately 10 cm and then redirected towards the lower abdomen.
Label: X

Sentence: The patient had no acute intrathoracic symptoms.
Label: 25

Now, please select the most appropriate label for the following sentence and output only the corresponding number. 
Notice: you only need to output label(pure numbers), do not output any other thing!
"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": sent}
    ]
    return messages