from pathlib import Path

# MIMIC constants
MIMIC_DATA_DIR = Path("./Dataset/MIMIC/")

MIMIC_MASTER_CSV_XH =  "mimic-cxr-label-LLM_report-xinhuo-chexpertformat.csv"

MIMIC_VALID_NUM = 5000
MIMIC_VIEW_COL = "Frontal/Lateral"
MIMIC_PATH_COL = "Path"
MIMIC_SPLIT_COL = "Split"
MIMIC_REPORT_COL = "Report Impression"
MIMIC_LLM_REPORT_COL = "LLM Report Impression"
MIMIC_XH_REPORT_COL = "xinhuo"
MIMIC_LLM_REPORT_V1_COL = "LLM Report v1 Impression"
MIMIC_DataFlag_COL = "Data Flag"
MIMIC_RAMINDEX_COL = "Index"
MIMIC_Original_VIEW_COL = "OriginalView"

PWD_Path = './Dataset/MIMIC-CXR-JPG/2.0.0/'

SENT_Path = 'LLM_cut_report_final.csv'
LABEL_Path = 'LLM_sent_label_final.csv'
MIMIC_label = 'MIMIC_multi_label_text.json'

# OpenI constants
OpenI_DATA_DIR = "./Dataset/OpenI/"
OpenI_ABS_PATH = "/mnt/nvme_share/wuwl/dataset/Open-I/"
OpenI_TRAIN_CSV = OpenI_DATA_DIR + "openi_multi_label_image.csv"  # train split from train.csv
OpenI_TEST_INPUT_CSV = OpenI_DATA_DIR + "test_input.csv"  # test input split from train.csv
OpenI_TEST_LABEL_CSV = OpenI_DATA_DIR + "test_label.csv"  # test label split from train.csv
OpenI_LABEL_CSV = OpenI_DATA_DIR + "custom.csv"
OpenI_VIEW_COL = "Frontal/Lateral"
OpenI_PATH_COL = "Path"
OpenI_pathologies = [
    "Atelectasis",
    "Cardiomegaly",
    "Effusion",
    "Infiltration",
    "Mass",
    "Nodule",
    "Pneumonia",
    "Pneumothorax",
    "Edema",
    "Emphysema",
    "Fibrosis",
    "Pleural_Thickening",
    "Hernia",
    "Fracture",
    "Opacity",
    "Lesion",
    "Calcified Granuloma",
    "Granuloma",
    "No_Finding"
]

# ChestXray14 constants
ChestXray14_DATA_DIR = "./Dataset/ChestXray14/"
ChestXray14_ABS_PATH = "/mnt/nvme_share/wuwl/dataset/ChestXray14/"
ChestXray14_TRAIN_DATA = ChestXray14_DATA_DIR + "test_list.txt"
ChestXray14_TEST_INPUT_CSV = ChestXray14_DATA_DIR + "test_input.csv"  # test input split from train.csv
ChestXray14_TEST_LABEL_CSV = ChestXray14_DATA_DIR + "test_label.csv"  # test label split from train.csv
ChestXray14_VIEW_COL = "Frontal/Lateral"
ChestXray14_PATH_COL = "path"
ChestXray14_pathologies = [
    'Atelectasis',
    'Cardiomegaly',
    'Effusion',
    'Infiltration',
    'Lung Mass',
    'Lung Nodule',
    'Pneumonia',
    'Pneumothorax',
    'Consolidation',
    'Edema',
    'Emphysema',
    'Fibrosis',
    'Pleural Thickening',
    'Hernia'
]

# ChestXDet10 constants
ChestXDet10_DATA_DIR = "./Dataset/ChestXDet10/"
ChestXDet10_ABS_PATH = "/mnt/nvme_share/wuwl/dataset/ChestXDet10/"
ChestXDet10_TRAIN_INPUT = ChestXDet10_DATA_DIR + "chestXDet10_test_image.csv"
ChestXDet10_TRAIN_LABEL = ChestXDet10_DATA_DIR + "test.json"
ChestXDet10_TEST_INPUT_CSV = ChestXDet10_DATA_DIR + "test_input.csv"  # test input split from train.csv
ChestXDet10_TEST_LABEL_CSV = ChestXDet10_DATA_DIR + "test_label.csv"  # test label split from train.csv
ChestXDet10_VIEW_COL = "Frontal/Lateral"
ChestXDet10_PATH_COL = "Path"
ChestXDet10_pathologies = [
    'Atelectasis',
    'Calcification',
    'Consolidation',
    'Effusion',
    'Emphysema',
    'Fibrosis',
    'Fracture',
    'Mass',
    'Nodule',
    'Pneumothorax'
]