import pandas as pd
import numpy as np

def split_csv(data, output_prefix, chunk_size=20000):
    total_rows = len(data)
    num_chunks = (total_rows // chunk_size) + 1
    for i in range(num_chunks):
        start_row = i * chunk_size
        end_row = start_row + chunk_size
        chunk = data[start_row:end_row]
        output_file = f"{output_prefix}_{i + 1}.csv"
        chunk.to_csv(output_file, index=False, header=False)
        print(f"Saved {output_file}")

filepaths_df = '/mnt/nvme_share/wuwl/project/CARZero-main/Dataset/MIMIC_temp/cut_report_part_final.csv'
data_df = pd.read_csv(filepaths_df, header=None)

split_csv(data_df, '/mnt/nvme_share/wuwl/project/CARZero-main/Dataset/MIMIC_new/cut_report_part', chunk_size=20000)