import pandas as pd
import json

# Input and output file paths
jsonl_file = 'results.jsonl'
csv_file = 'results.csv'

# Read JSONL file into a list of dictionaries
data = []
results = [json.loads(line) for line in open(jsonl_file)]
for result in results:
    for entry in ["by_task", "by_source"]:
        result["name"] = result["name"].replace("./playground/data/eval/cvbench/answers/", "").replace(".jsonl", "").replace("/","\n")
        for k, v in result[entry].items():
            result[k] = v
        result.pop(entry, None)
    data.append(result)

# Convert to DataFrame
df = pd.DataFrame(data)
df = df.transpose()

# Save to CSV
df.to_csv(csv_file, index=True)

print(f"Converted {jsonl_file} to {csv_file}")