#!/bin/bash
CKPT=${1:-"llava-v1.5-7b"}

if [ ! -f "./playground/data/eval/cvbench/answers/$CKPT.jsonl" ]; then
    python -m llava.eval.model_vqa_loader \
        --model-path checkpoints/$CKPT \
        --question-file ./playground/data/eval/cvbench/llava_cvbench_test_v2.jsonl \
        --image-folder ./playground/data/eval/cvbench/ \
        --mask-folder ./playground/data/regions/cvbench/regions-mixed \
        --answers-file ./playground/data/eval/cvbench/answers/$CKPT.jsonl \
        --temperature 0 \
        --max_new_tokens 64 \
        --conv-mode vicuna_v1
fi

python llava/eval/eval_cvbench.py \
    --question-file ./playground/data/eval/cvbench/llava_cvbench_test_v2.jsonl \
    --result-file ./playground/data/eval/cvbench/answers/$CKPT.jsonl \
    --result-save ./playground/data/eval/cvbench/scores/$CKPT.json
