#!/bin/bash

SPLIT="mmbench_dev_20230712"
CKPT=${1:-"llava-v1.5-7b"}

python -m llava.eval.model_vqa_mmbench \
    --model-path checkpoints/$CKPT \
    --model-kwargs '{"region_filter": "corner_heuristic"}' \
    --question-file ./playground/data/eval/mmbench/$SPLIT.tsv \
    --mask-folder ./playground/data/regions/mmbench/regions-mixed \
    --answers-file ./playground/data/eval/mmbench/answers/$SPLIT/$CKPT-corner.jsonl \
    --single-pred-prompt \
    --temperature 0 \
    --conv-mode vicuna_v1

mkdir -p playground/data/eval/mmbench/answers_upload/$SPLIT

python scripts/convert_mmbench_for_submission.py \
    --annotation-file ./playground/data/eval/mmbench/$SPLIT.tsv \
    --result-dir ./playground/data/eval/mmbench/answers/$SPLIT \
    --upload-dir ./playground/data/eval/mmbench/answers_upload/$SPLIT \
    --experiment $CKPT-corner
