#!/bin/bash

CKPT=${1:-"llava-v1.5-7b"}

if [ ! -f "./playground/data/eval/mmstar/scores/$CKPT.json" ]; then
    python -m llava.eval.model_vqa_mmstar \
        --model-path checkpoints/$CKPT \
        --answers-file ./playground/data/eval/mmstar/answers/$CKPT.jsonl \
        --single-pred-prompt \
        --temperature 0 \
        --conv-mode vicuna_v1
fi

python llava/eval/eval_mmstar.py \
    --result-file ./playground/data/eval/mmstar/answers/$CKPT.jsonl \
    --result-save ./playground/data/eval/mmstar/scores/$CKPT.json