#!/bin/bash

CKPT=${1:-"llava-v1.5-7b"}

if [ ! -f "./playground/data/eval/ocrbench/scores/$CKPT.json" ]; then
    python -m llava.eval.model_vqa_ocr \
        --model-path checkpoints/$CKPT \
        --mask-folder ./playground/data/regions/ocrbench/regions-mixed \
        --answers-file ./playground/data/eval/ocrbench/answers/$CKPT.jsonl \
        --temperature 0 \
        --conv-mode vicuna_v1
fi

python llava/eval/eval_ocr.py \
    --result-file ./playground/data/eval/ocrbench/answers/$CKPT.jsonl \
    --result-save ./playground/data/eval/ocrbench/scores/$CKPT.json