#!/bin/bash
CKPT=${1:-"llava-v1.5-7b"}

if [ ! -f "./playground/data/eval/pope/scores/$CKPT.json" ]; then
    python -m llava.eval.model_vqa_loader \
        --model-path checkpoints/$CKPT \
        --question-file ./playground/data/eval/pope/llava_pope_test.jsonl \
        --image-folder ./playground/data/eval/pope/val2014 \
        --mask-folder ./playground/data/regions/pope/regions-mixed \
        --answers-file ./playground/data/eval/pope/answers/$CKPT.jsonl \
        --temperature 0 \
        --conv-mode vicuna_v1
fi

python llava/eval/eval_pope.py \
    --annotation-dir ./playground/data/eval/pope/coco \
    --question-file ./playground/data/eval/pope/llava_pope_test.jsonl \
    --result-file ./playground/data/eval/pope/answers/$CKPT.jsonl \
    --result-save ./playground/data/eval/pope/scores/$CKPT.json
