#!/bin/bash
resolution=${1:-384}
norm=${2:-"none"}
select_feature=${3:-"sum_patch"}
region_extra=${4:-"global"}
region_sort=${5:-"com_patch"}
exp_name=${6:-"Rllava-v0.48-ca1x-7b"}

export WANDB_ENTITY=Your_space
export WANDB_PROJECT=LLaVA
export WANDB_RESUME=allow
export WANDB__SERVICE_WAIT=300
export WANDB_HTTP_TIMEOUT=300
export WANDB_INIT_TIMEOUT=600

job_name=radio/${exp_name}-pretrain
export WANDB_RUN_ID=${job_name/\//\_}

vision_tower=radio_v2.5-l
deepspeed llava/train/train_mem.py \
    --deepspeed ./scripts/zero2.json \
    --model_name_or_path lmsys/vicuna-7b-v1.5 \
    --version plain \
    --region_based True \
    --region_sort $region_sort \
    --region_interpolate downsample_crop \
    --region_pooling_method average \
    --region_extra $region_extra \
    --region_filter none \
    --data_path ./playground/data/LLaVA/LLaVA-Pretrain/blip_laion_cc_sbu_558k.json \
    --mask_folder ./playground/data/regions/LLaVA-Pretrain/regions-mixed \
    --image_folder ./playground/data/LLaVA/LLaVA-Pretrain/images \
    --vision_tower $vision_tower \
    --mm_projector_type mlp2x_gelu \
    --tune_mm_mlp_adapter True \
    --mm_vision_feature_pe $norm \
    --mm_vision_select_layer -2 \
    --mm_vision_select_feature $select_feature \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --mm_force_imsize $resolution \
    --bf16 True \
    --output_dir ./checkpoints/$job_name \
    --num_train_epochs 1 \
    --per_device_train_batch_size 32 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 2 \
    --eval_strategy "no" \
    --save_strategy "no" \
    --save_steps 24000 \
    --save_total_limit 1 \
    --learning_rate 1e-3 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 10 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb \
    --run_name $job_name


export WANDB_PROJECT=LLaVA_ft
job_name=radio/${exp_name}
export WANDB_RUN_ID=${job_name/\//\_}

vision_tower=radio_v2.5-l
deepspeed llava/train/train_mem.py \
    --deepspeed ./scripts/zero2.json \
    --model_name_or_path lmsys/vicuna-7b-v1.5 \
    --version v1 \
    --region_based True \
    --region_sort $region_sort \
    --region_interpolate downsample_pad \
    --region_pooling_method average \
    --region_extra $region_extra \
    --region_filter none \
    --data_path ./playground/data/LLaVA/llava_v1_5_mix665k.json \
    --mask_folder ./playground/data/regions/LLaVA-ft/regions-mixed-v2 \
    --image_folder ./playground/data/LLaVA \
    --vision_tower $vision_tower \
    --pretrain_mm_mlp_adapter ./checkpoints/${job_name}-pretrain/mm_projector.bin \
    --mm_projector_type mlp2x_gelu \
    --mm_vision_feature_pe $norm \
    --mm_vision_select_layer -2 \
    --mm_vision_select_feature $select_feature \
    --mm_use_im_start_end False \
    --mm_use_im_patch_token False \
    --mm_force_imsize $resolution \
    --image_aspect_ratio pad \
    --group_by_modality_length True \
    --bf16 True \
    --output_dir ./checkpoints/$job_name \
    --num_train_epochs 1 \
    --per_device_train_batch_size 16 \
    --per_device_eval_batch_size 4 \
    --gradient_accumulation_steps 2 \
    --eval_strategy "no" \
    --save_strategy "no" \
    --save_steps 50000 \
    --save_total_limit 1 \
    --learning_rate 2e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 10 \
    --tf32 True \
    --model_max_length 2048 \
    --gradient_checkpointing True \
    --dataloader_num_workers 4 \
    --lazy_preprocess True \
    --report_to wandb \
    --run_name $job_name
