SPLIT=${1:-"-1"}

python region_features/generate_regions.py \
    --input ./playground/data/LLaVA/LLaVA-Pretrain/images/ \
    --data_path ./playground/data/LLaVA/LLaVA-Pretrain/splits/blip_laion_cc_sbu_558k_${SPLIT}_of_32.json \
    --output ./playground/data/regions/LLaVA-Pretrain/regions-mixed \
    --checkpoint "./playground/models/sam2/sam2.1_hiera_large.pt" \
    --use-sam2 \
    --sam2-model-cfg sam2.1_hiera_l.yaml \
    --num-granularities 3 \
    --points-per-side 48 64 96 \
    --points-per-batch 128 \
    --pred-iou-thresh 0.6 0.5 0.4 \
    --stability-score-thresh 0.92 0.9 0.85 \
    --min-mask-region-area 10 \
    --nmasks-soft-min 80 \
    --convert-to-rle \
    # --overwrite
    # --visualize
