from yacs.config import CfgNode as CN

_C = CN()

_C.SYSTEM = CN()
# Number of GPUS to use in the experiment
_C.SYSTEM.NUM_GPUS = 1
# Number of workers in dataloader
_C.SYSTEM.NUM_WORKERS = 6
_C.SYSTEM.SEED = 123
_C.SYSTEM.DEBUGGING_LEVEL = "INFO"
_C.SYSTEM.OUT_DIR = "/n/fs/nlp-xxxx/projects/world-models/checkpoints/debug"

_C.VIST = CN()
_C.VIST.MAX_LEN_CAPTION = 20
_C.VIST.NUM_DISTRACTORS = 4
_C.VIST.OVERFIT = False
_C.VIST.DATASET_SAMPLE_OVERFIT = 10
_C.VIST.GENERATED_CAPTIONS_PATH_TRAIN = ""
_C.VIST.GENERATED_CAPTIONS_PATH_VAL = ""
_C.VIST.GENERATED_CAPTIONS_PATH_TEST = ""
_C.VIST.GENERATED_STORIES_PATH_TRAIN = ""
_C.VIST.GENERATED_STORIES_PATH_VAL = ""
_C.VIST.GENERATED_STORIES_PATH_TEST = ""

_C.VIST.DISTRACTOR_PATH_TRAIN = ""
_C.VIST.DISTRACTOR_PATH_VAL = ""
_C.VIST.DISTRACTOR_PATH_TEST = ""

_C.VIST.CAPTION_TYPE = "stories"
_C.VIST.DII_ROOT = "/n/fs/nlp-xxxx/datasets/VIST/dii"
_C.VIST.DIS_ROOT = "/n/fs/nlp-xxxx/datasets/VIST/dis"
_C.VIST.SIS_ROOT = "/n/fs/nlp-xxxx/datasets/VIST/sis"
_C.VIST.IMG_ROOT = "/n/fs/nlp-xxxx/datasets/VIST/images"
_C.VIST.IMG_FEAT_ROOT = "/n/fs/nlp-xxxx/datasets/VIST/images/resnet-101/fc"
_C.VIST.IMG_FEAT_SIZE = 2048
_C.VIST.LSTM_HIDDEN_DIM = 256
_C.VIST.LSTM_LAYERS = 2
_C.VIST.LSTM_DROPOUT = 0.1
_C.VIST.BATCH_PER_GPU = 16
_C.VIST.NUM_EPOCHS = 10
_C.VIST.MODEL_TYPE = "BERT"
_C.VIST.MODEL_PATH = "bert-base-uncased"
_C.VIST.CAPTION_TYPE = "stories"
_C.VIST.DROPOUT = 0.1
_C.VIST.MARGIN = 1

_C.VIST.LR = 5e-5
_C.VIST.LOG_EVERY = 20
_C.VIST.SAVE_EVERY_N_EPOCHS = 1
_C.VIST.GRAD_ACC=6
_C.VIST.TRAIN_MODE="bert-finetune"

_C.TV = CN()
_C.TV.MAX_LEN_CAPTION = 20
_C.TV.OVERFIT = False
_C.TV.DATASET_SAMPLE_OVERFIT = 10
_C.TV.GENERATED_CAPTIONS_PATH_TRAIN = ""
_C.TV.GENERATED_CAPTIONS_PATH_TEST = ""
_C.TV.IMAGE_ROOT = "/u/xxxx/world-models/data/tv-interaction/tv_human_interactions_videos"
_C.TV.DATA_ROOT = "/u/xxxx/world-models/data/tv-interaction"
_C.TV.BATCH_PER_GPU = 16
_C.TV.NUM_EPOCHS = 10
_C.TV.MODEL_TYPE = "ROBERTA"
_C.TV.MODEL_PATH = "roberta-base"
_C.TV.NUM_CAPTIONS = 3
_C.TV.LR = 2e-5
_C.TV.LOG_EVERY = 1
_C.TV.SAVE_EVERY_N_EPOCHS = 1
_C.TV.EVALUATE_DURING_TRAINING = True
_C.TV.EVALUATE_EVERY_N_EPOCHS = 10
_C.TV.DROPOUT = 0.1
_C.TV.KFOLDS = 25

def get_cfg_defaults():
    """Get a yacs CfgNode object with default values for my_project."""
    # Return a clone so that the defaults will not be altered
    # This is for the "local variable" use pattern
    return _C.clone()
