#!/bin/bash
#SBATCH --job-name=vist
#SBATCH --output=logs/%x-%j.out
#SBATCH --mem=64G
#SBATCH --time=0-6:00:00    # Run for 6 hours
export PYTHONPATH=/u/xxxx/bottom-up-attention/lib:/u/xxxx/bottom-up-attention/caffe/python:/u/xxxx/bottom-up-attention/tools

NUM_GROUPS=5
OUT="/u/xxxx/world-models/data/VIST"
SPLIT="test"
for i in $(seq 0 $[NUM_GROUPS-1]);
do
    sbatch -A pnlp --time=0-6:00:00  --mem=32G --output=logs/%x-%j.out --job-name=vist_${SPLIT}_$i  --gres=gpu:1 ./run_job.sh "conda activate butd" "cd /u/xxxx/bottom-up-attention" "./tools/generate_tsv.py --gpu 0 --group_id=$i --total_group=$NUM_GROUPS --cfg experiments/cfgs/faster_rcnn_end2end_resnet.yml --def models/vg/ResNet-101/faster_rcnn_end2end_final/test.prototxt --out ${OUT}/VIST_$SPLIT --net data/faster_rcnn_models/resnet101_faster_rcnn_final.caffemodel --split VIST_$SPLIT"
done
#sbatch -A pnlp --gres=gpu:1 
# ./tools/generate_tsv.py --gpu 0 --group_id=$i --total_group=$NUM_GROUPS --cfg experiments/cfgs/faster_rcnn_end2end_resnet.yml --def models/vg/ResNet-101/faster_rcnn_end2end_final/test.prototxt --out ${OUT}/VIST_$SPLIT --net data/faster_rcnn_models/resnet101_faster_rcnn_final.caffemodel --split VIST_$SPLIT"