#!/usr/bin/env bash

function download_google_drive {
    fileid=$1
    filename=$2
    echo $fileid
    echo $filename
    curl -c ./cookie -s -L "https://drive.google.com/uc?export=download&id=${fileid}" > /dev/null
    curl -Lb ./cookie "https://drive.google.com/uc?export=download&confirm=`awk '/download/ {print $NF}' ./cookie`&id=${fileid}" -o ${filename}
}

mkdir -p data/VIST
# get train images
cd data/VIST
download_google_drive 1fM0CclK3FVKU0_Q4GeVt6KYDDeV364m2 v1-2-test.tar.gz
# download_google_drive 0ByQS_kT8kViSeEpDajIwOUFhaGc train_split.0.tar.gz
# download_google_drive 0ByQS_kT8kViSZnZPY1dmaHJzMHc train_split.1.tar.gz
download_google_drive 0ByQS_kT8kViSb0VjVDJ3am40VVE train_split.2.tar.gz
download_google_drive 0ByQS_kT8kViSTmQtd1VfWWFyUHM train_split.3.tar.gz
download_google_drive 0ByQS_kT8kViSQ1ozYmlITXlUaDQ train_split.4.tar.gz
download_google_drive 0ByQS_kT8kViSTVY1MnFGV0JiVkk train_split.5.tar.gz
download_google_drive 0ByQS_kT8kViSYmhmbnp6d2I4a2M train_split.6.tar.gz
download_google_drive 0ByQS_kT8kViSZl9aNGVuX0llcEU train_split.7.tar.gz
download_google_drive 0ByQS_kT8kViSWXJ3R3hsZllsNVk train_split.8.tar.gz
download_google_drive 0ByQS_kT8kViSR2N4cFpweURhTjg train_split.9.tar.gz
download_google_drive 0ByQS_kT8kViScllKWnlaVU53Skk train_split.10.tar.gz
download_google_drive 0ByQS_kT8kViSV2QxZW1rVXcxT1U train_split.11.tar.gz
download_google_drive 0ByQS_kT8kViSNGNPTEFhdGxkMnM train_split.12.tar.gz
# get val and test
download_google_drive 0ByQS_kT8kViSWmtRa1lMcG1EaHc val_images.tar.gz
download_google_drive 0ByQS_kT8kViSTHJ0cGxSVW1SRFk test_images.tar.gz
# get text annotations

# wget https://visionandlanguage.net/VIST/json_files/description-in-isolation/DII-with-labels.tar.gz
# wget https://visionandlanguage.net/VIST/json_files/story-in-sequence/SIS-with-labels.tar.gz

# untar files

tar xvzf train_split.0.tar.gz
tar xvzf train_split.1.tar.gz
tar xvzf train_split.2.tar.gz
tar xvzf train_split.3.tar.gz
tar xvzf train_split.4.tar.gz
tar xvzf train_split.5.tar.gz
tar xvzf train_split.6.tar.gz
tar xvzf train_split.7.tar.gz
tar xvzf train_split.8.tar.gz
tar xvzf train_split.9.tar.gz
tar xvzf train_split.10.tar.gz
tar xvzf train_split.11.tar.gz
tar xvzf train_split.12.tar.gz

tar xvzf val_images.tar.gz
tar xvzf test_images.tar.gz

tar xvzf DII-with-labels.tar.gz
tar xvzf SIS-with-labels.tar.gz

# remove downloaded archives

# rm -f train_split.0.tar.gz
# rm -f train_split.1.tar.gz
# rm -f train_split.2.tar.gz
# rm -f train_split.3.tar.gz
# rm -f train_split.4.tar.gz
# rm -f train_split.5.tar.gz
# rm -f train_split.6.tar.gz
# rm -f train_split.7.tar.gz
# rm -f train_split.8.tar.gz
# rm -f train_split.9.tar.gz
# rm -f train_split.10.tar.gz
# rm -f train_split.11.tar.gz
# rm -f train_split.12.tar.gz

# rm -f val_images.tar.gz
# rm -f test_images.tar.gz

# rm -f DII-with-labels.tar.gz
# rm -f SIS-with-labels.tar.gz
