# generate coco format captions files from VIST json files

import argparse
import glob
import json
import os


def read_options(argv=None):
    parser = argparse.ArgumentParser(description="Options")
    # -------------------------------------------------------------------------
    # Data input settings
    parser.add_argument(
        "-vist_train_descriptions",
        default="data/VIST/dii/train.description-in-isolation.json",
        help="json file containing train split of VIST caption data",
    )

    parser.add_argument(
        "-vist_val_descriptions",
        default="data/VIST/dii/val.description-in-isolation.json",
        help="json file containing val split of VIST caption data",
    )
    parser.add_argument(
        "-vist_test_descriptions",
        default="data/VIST/dii/test.description-in-isolation.json",
        help="json file containing test split of VIST caption data",
    )
    # -------------------------------------------------------------------------
    # Logging settings

    parser.add_argument(
        "-save_path_train_prefix",
        default="/n/fs/nlp-xxxx/datasets/VIST/preprocessed/VIST_train",
        help="Path to save processed train json",
    )
    parser.add_argument(
        "-save_path_val_prefix",
        default="/n/fs/nlp-xxxx/datasets/VIST/preprocessed/VIST_val",
        help="Path to save val json",
    )
    parser.add_argument(
        "-save_path_test_prefix",
        default="/n/fs/nlp-xxxx/datasets/VIST/preprocessed/VIST_test",
        help="Path to save test json",
    )

    try:
        parsed = vars(parser.parse_args(args=argv))
    except IOError as msg:
        parser.error(str(msg))
    return parsed


# captions file
# {
#     "image_id": "179765",
#     "id": 38,
#     "caption": "A black Honda motorcycle parked in front of a garage."
# },

# coco format
# {
#     "image_id": "179765",
#     "caption": "A black Honda motorcycle parked in front of a garage.",
#     "id": 0
# },
# {
#     "id": "179765",
#     "file_name": "179765"
# },


def generate_captions(VIST_split_file, out_file, out_file_coco):
    with open(VIST_split_file) as f_vist:
        vist_data = json.load(f_vist)
    data_captions = []
    data_captions_coco = {
        "type": "captions",
        "info": "dummy",
        "licenses": "dummy",
        "images": [],
        "annotations": [],
    }
    image_id_2_annotation_idx = {}
    for j, annotation in enumerate(vist_data["annotations"]):
        image_id_2_annotation_idx[annotation[0]["photo_flickr_id"]] = j
    for image in vist_data["images"]:
        image_id = image["id"]
        caption = ""
        if image_id in image_id_2_annotation_idx:
            caption = vist_data["annotations"][image_id_2_annotation_idx[image_id]][0][
                "original_text"
            ]
        # else:
        #     continue

        data_captions_coco["images"].append(
            {"id": str(image_id), "filename": str(image_id)}
        )
        data_captions_coco["annotations"].append(
            {
                "id": str(image_id),
                "image_id": str(image_id),
                "filename": str(image_id),
                "caption": caption,
            }
        )
        data_captions.append(
            {"image_id": str(image_id), "id": image_id, "caption": caption}
        )
    with open(out_file_coco, "w") as f_coco:
        json.dump(data_captions_coco, f_coco)

    with open(out_file, "w") as f_cap:
        json.dump(data_captions, f_cap)


if __name__ == "__main__":
    params = read_options()
    generate_captions(
        params["vist_train_descriptions"],
        params["save_path_train_prefix"] + "_caption.json",
        params["save_path_train_prefix"] + "_caption_coco_format.json",
    )
    generate_captions(
        params["vist_val_descriptions"],
        params["save_path_val_prefix"] + "_caption.json",
        params["save_path_val_prefix"] + "_caption_coco_format.json",
    )
    generate_captions(
        params["vist_test_descriptions"],
        params["save_path_test_prefix"] + "_caption.json",
        params["save_path_test_prefix"] + "_caption_coco_format.json",
    )
