from pyswip import Prolog
from typing import List, Tuple
import os
import argparse
import re


def add_meta_commands(file_path: str, meta_path: str):

    with open(meta_path, 'r') as file:
        meta_commands = file.readlines()

    lines, query = get_code_from_file(file_path)

    if 'query' not in query:
        raise ValueError('Query format is not correct')
    
    if len(query.split(':-')) > 1:
        lines += [query]
    else:
        full_stop = '' if query.endswith('.') else '.'
        lines += [f'query :- {query}{full_stop}']

    lines += meta_commands

    if os.path.exists(f"{file_path.split('.')[0]}_meta_added.pl"):
        os.remove(f"{file_path.split('.')[0]}_meta_added.pl")

    with open(f"{file_path.split('.')[0]}_meta_added.pl", 'w') as file:
        for line in lines:
            file.write(line + '\n')

    return lines
        

def get_code_from_file(file_path: str) -> Tuple[List[str], str]:
    # query is the last line of the file
    with open(file_path, 'r') as file:
        lines = file.readlines()

    lines = [line.strip() for line in lines if line.strip() != '']

    query = lines[-1].strip()
    if query.startswith('%'):
        query = query.replace('%', '')
    if query.startswith('?-'):
        query = query.replace('?-', '')
    if query.endswith('.'):
        query = query[:-1]

    return lines, query


def run_prolog(file_path):
    prolog = Prolog()
    _, query = get_code_from_file(file_path)

    print(f"Query: {query}")

    prolog.consult(file_path)
    
    results = list(prolog.query(query))
    return results

if __name__ == '__main__':

    parser = argparse.ArgumentParser(description='Run prolog code')
    parser.add_argument('file', type=str, help='Path to the file with prolog code')
    args = parser.parse_args()

    meta_path = os.path.join(os.path.dirname(__file__), 'meta_interp_tree.pl')

    results = run_prolog(args.file)
    print(results)

    lines = add_meta_commands(args.file, meta_path)



# example usage
# python run_prolog.py example.pl