import sys
sys.path.append("..")
import os 
import numpy as np
import torch
import matplotlib.pyplot as plt
import cv2
from tqdm import tqdm 
import torch
from PIL import Image
import open_clip
import matplotlib.patches as patches
import pickle
from sklearn.cluster import KMeans, DBSCAN
import torchvision
import torch
import pandas as pd 
import itertools


def get_prompts(CONCEPT):

    raw_data = pd.read_csv("../data/prompts_pairwise_adj.csv")
    templates = raw_data["template"].dropna().tolist()[:-1]
    pairwise_adjs = []
    for row in raw_data.iterrows():
        pairwise_adjs.append((row[1]["positive adj"], row[1]["negative adj"]))

    pair = [pair for pair in pairwise_adjs if CONCEPT in pair][0]

    prompts = []
    for template in templates:
        template = template.strip()
        if not template:
            continue
        prompts.append([template.format(concept) for concept in pair])
    return prompts, pair

