import os
import torch
import torchvision
import torchvision.transforms as transforms
from torch.utils.data import DataLoader
from torchvision.datasets import MNIST
import numpy as np

dataset_path = './data' 
noisy_dataset_train_path = 'data/noisy_mnist/train'
noisy_dataset_test_path = 'data/noisy_mnist/test'

if not os.path.exists(noisy_dataset_train_path):
    os.makedirs(noisy_dataset_train_path)

if not os.path.exists(noisy_dataset_test_path):
    os.makedirs(noisy_dataset_test_path)
    
transform = transforms.Compose([transforms.ToTensor()])

train_set = MNIST(root=dataset_path, train=True, download=True, transform=transform)
test_set = MNIST(root=dataset_path, train=False, download=True, transform=transform)

train_loader = DataLoader(train_set, batch_size=1, shuffle=False)
test_loader = DataLoader(test_set, batch_size=1, shuffle=False)

def add_noise(img):
    # noise = torch.rand(img.size()) * 0.05 
    noise = torch.abs(torch.randn(img.size()) * 0.05)
    noisy_img = img + noise
    noisy_img = torch.clamp(noisy_img, 0., 1.)
    return noisy_img

def save_noisy_images_and_labels(loader, folder):
    labels_file = open(os.path.join(folder, 'labels.txt'), 'w')
    
    for i, (images, labels) in enumerate(loader):
        noisy_images = add_noise(images)
        image_filename = f'noisy_mnist_{i}.png'
        torchvision.utils.save_image(noisy_images, os.path.join(folder, image_filename))
        labels_file.write(f'{image_filename} {labels.item()}\n')
    
    labels_file.close()

save_noisy_images_and_labels(train_loader, noisy_dataset_train_path)
print(f'Noisy MNIST images saved to {noisy_dataset_train_path}')
save_noisy_images_and_labels(test_loader, noisy_dataset_test_path)
print(f'Noisy MNIST images saved to {noisy_dataset_test_path}')
