# Morpher-Exp

## Environment Setup 

### Windows with CUDA 12.X
```
conda create -n morpher python=3.9.18
pip3 install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu121
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.3.0+cu121.html
pip install transformers
pip install scikit-learn yacs
pip install pytorch_lightning
```



### Linux with CUDA 12.X
```
conda create -n morpher python=3.9.18
pip3 install torch torchvision torchaudio
pip install torch_geometric
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.3.0+cu121.html
pip install transformers
pip install scikit-learn yacs
pip install pytorch_lightning
```



## Quick Start: All-in-one is our Improved version of AIO, main.py is Morpher.
### MUTAG with GraphCL pre-trained GCN
```
python downstream_task.py --task GraphTask --dataset_name MUTAG --gnn_type GCN --pretrain_method GraphCL --prompt_type All-in-one

python main.py --dataset MUTAG --gnn GCN --pretrain_method GraphCL
```


### Domain Transfer from ENZYMES to MUTAG
```
python downstream_task.py --transfer --dataset_name MUTAG --gnn_type GCN --pretrain_method GraphCL --prompt_type All-in-one --source ENZYMES

python main.py --dataset MUTAG --gnn GCN --pretrain_method GraphCL --task transfer --source ENZYMES
```


### Node and Edge Level Tasks
Because the pre-trained GNN is too large, we cannot submit it in the supplementary material. Please download the pre-trained GNN and place it in the pre_trained_gnn folder first.
The download link is: 

https://drive.google.com/file/d/1on-fjNZ3k1PiKhYwBmOom4nHUk9G9wqv/view?usp=sharing

Node tasks:
```
python downstream_task.py --task node --dataset_name Cora --gnn_type GCN --pretrain_method GraphCL --prompt_type All-in-one

python main.py --dataset Cora --gnn GCN --pretrain_method GraphCL --task node
```
Edge tasks:
```
python downstream_task.py --task edge --dataset_name Cora --gnn_type GCN --pretrain_method GraphCL --prompt_type All-in-one

python main.py --dataset Cora --gnn GCN --pretrain_method GraphCL --task edge
```



### Zero-shot Protytype
The code for our zero-shot prototype based on Morpher is provided in another folder, Morpher-Zeroshot. We also provide a README in that folder.




## Pre-train a GNN for other tests
```
python pre_train.py --task GraphCL --dataset_name MUTAG --gnn_type GCN --hid_dim 128 --num_layer 2 --batch_size 10 --epochs 20 --seed 42 --lr 0.01 --decay 0.0001
```