# Morpher-Zeroshot-Prototype




## Environment Setup 

### Windows with CUDA 12.X
```
conda create -n morpher python=3.9.18
pip3 install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu121
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.3.0+cu121.html
pip install transformers
pip install scikit-learn yacs
pip install pytorch_lightning
```



### Linux with CUDA 12.X
```
conda create -n morpher python=3.9.18
pip3 install torch torchvision torchaudio
pip install torch_geometric
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.3.0+cu121.html
pip install transformers
pip install scikit-learn yacs
pip install pytorch_lightning
```


## (Optional) Pre-train GNN
```
python pre_train.py --task GraphCL --dataset_name zero1 --gnn_type GCN --hid_dim 2 --num_layer 2 --epochs 20 --seed 42 --lr 0.0001 --decay 0.00001

python pre_train.py --task GraphCL --dataset_name zero2 --gnn_type GCN --hid_dim 2 --num_layer 2 --epochs 20 --seed 42 --lr 0.0001 --decay 0.00001

python pre_train.py --task GraphCL --dataset_name zero3 --gnn_type GCN --hid_dim 2 --num_layer 2 --epochs 20 --seed 42 --lr 0.0001 --decay 0.00001
```


## Zero-shot experiment
```
python zeroshot.py --dataset_name zero1

python zeroshot.py --dataset_name zero2

python zeroshot.py --dataset_name zero3
```