# Understanding Transformers for Time Series: Rank Structure, Flow-of-ranks, and Compressibility

This directory contains codes that are used to investigate the role of a low-rank structure in time-series foundation models and how it can be used to compress the models.

This folder is organized as follows.

* [`evaluation-scripts`](./evaluation-scripts/): containing the evaluation script that we used to evaluate Chronos models and T5 large language models compressed after pretraining.

* [`T5-variants`](./T5-variants/): containing a variant of T5 models that we developed that incorporates the compression strategies with flow-of-ranks. When pretraining a compressed Chronos model, replace the original T5 script in your `transformer` Pytorch package with [this file](./T5-variants/modeling_t5_dense_flowofranks.py) and [its configuration](./T5-variants/configuration_t5.py).