## Setup
```
conda create -n temporalportllm python=3.10 -y && conda activate temporalportllm
pip3 install -r requirements.txt
git clone --depth 1 https://github.com/EleutherAI/lm-evaluation-harness
cd lm-evaluation-harness
pip install -e .
cd ..
```

## Usage
**Note:** To fine-tune and use any of the models used in the paper, please make an account on huggingface, and sign in with your token using the huggingface CLI. If you would like to work with local models, this is not necessary.

## Fine-tuning on Downstream tasks
Replace {dataset} with downstream task you would like to fine-tune on.
```
accelerate launch scripts/run_{dataset}.py --max_length=256 --batch_size=4 --num_workers=8 --model_name_or_path="mistralai/Mistral-7B-v0.1" --rank=8 --lora_alpha=16 --lora_dropout=0.1 --lr=1e-4 --num_epochs=10 --seed=1234 --output_dir={OUTPUT_DIR}
```

## Continued Pretraining
For Continued Pretraining we utilize the Axolotl framework. The config files are under configs folder for Axolotl.

## Evaluation
To evaluate a model without its adapter on any dataset simply run the following command.
```
accelerate launch -m lm_eval --model hf --model_args "pretrained={MODEL}" --tasks "{TASKS}" --num_fewshot 0 --batch_size 32
```
If you would like to also evaluate the adapter performance run the following command
```
accelerate launch -m lm_eval --model hf --model_args "pretrained=mistralai/Mistral-7B-v0.1,peft={PEFT}" --tasks "boolq" --num_fewshot 0 --batch_size 32
```
To evaluate on Math Genie, use the config file located under lm_eval_tasks
## Merge Adapters
To merge adapters with the model itself please run the following command
```
python3 merge_adapters.py --base_model_name_or_path {BASE_MODEL} --peft_model_path {PEFT_MODEL} --output_dir {OUTPUT_DIR}
```