<!-- GETTING STARTED -->
## Getting Started

### Installation

1. First install a new conda environment with python 3.10
```sh
conda create -n simple-gpt python=3.10
```
OR
Setup a new virtual environment with python 3.10
```sh
python3 -m venv simple-gpt
```

2. Then activate the environment
```sh
conda activate myenv
```
3. Then install the required packages
```sh
pip install -r requirements.txt
```

4. Make sure you have your OPENAI API key in your environment variables
```sh
export OPENAI_API_KEY=<your key here>
```


<!-- USAGE EXAMPLES -->
## Usage
The human state-actio annotations are in eval_data/annotation

1. Put the Video2Demo generated state-action annotations in raw_data/Video2Demo/Video2Demo_*_output.json


2. Run the following command to generate the results
```sh
python main-llava-eval.py -v Video2Demo --eval_all --model gpt-3.5-turbo
```
It's recommended that you slightly parallelize it by having 2 terminals (2 cpus) running eval at the same time:
In one terminal:
```sh
python main-llava-eval.py -v Video2Demo --eval_1st_half
```
In another terminal:
```sh
python main-llava-eval.py -v Video2Demo --eval_2nd_half
```
