# LoRTA: Low Rank Tensor Adaptation of Large Language Models

This folder contains the code and resources accompanying the paper submission **"LoRTA: Low Rank Tensor Adaptation of Large Language Models"**, for ICLR 2025.

## Repository Structure

The repository is organized into three main directories, each corresponding to a key component of the LoRTA framework:

1. **`instruction_tuning/`**: Code and scripts related to instruction tuning for adapting LLama models using Alpaca. It is based on lightning GPT.
2. **`dpo/`** (Direct Policy Optimization):Implementation of Direct Policy Optimization for fine-tuning language models using a low-rank tensor decomposition. This includes:

   - Training routines and checkpoints
   - Performance benchmarks on specific policy tasks
   - Tensor adaptation modules
3. **`nlu/`** Contains the peft implementation of lora along with all the GLUE benchmark experiments. Based on VeRA code.
