#!/bin/bash

#SBATCH --output=/cluster/work/cvl/eeg_foundation/experiments/pretraining/waveform_pretraining/report_final_large_minmax.out
#SBATCH --parsable
#SBATCH --nodes=4
#SBATCH --tasks-per-node=4
#SBATCH --ntasks=16
#SBATCH --time=120:00:00
#SBATCH --cpus-per-task=3
#SBATCH --mem-per-cpu=10g
#SBATCH --gpus-per-node=rtx_4090:4


# srun --nodes=1 --tasks-per-node=1 --mem-per-cpu=10g --gpus-per-node=rtx_4090:1 --pty bash


# Send some noteworthy information to the output log
echo "Running on node: $(hostname)"
echo "In directory:    $(pwd)"
echo "Starting on:     $(date)"
echo "SLURM_JOB_ID:    ${SLURM_JOB_ID}"

nvidia-smi

# source /cluster/project/cvl/admin/cvl_settings
module load gcc/8.2.0 

source ~/miniconda3/etc/profile.d/conda.sh
conda activate timefmcu11
srun python -u run_train.py +experiments_pt_waveforms=final_simmim_pt_large