## Configs

Hydra configs specify how each python module in the repository should be used, and help with tracking our experiments. 

There are 3 types of configs:
- module configs: specify how one particular class should be used (criterions, data modules, preprocessors, models, model heads, schedulers and tasks). Each of these configs have a `_target_` specifying the location of the respective python class, as well as the default parameters of the respective class.
- experiment configs: these configs put together the module configs needed for one experiment. For example, one experiment might involve a `simmim` model, with a `mlp_classification_head` model head for finetuning, thus utilizing the task `finetuning_pretrained_model`. In addition, datasets are specified here, loading a pre-trained checkpoint, as well as any other parameters that might be necessary for the experiment. Experiment configs can be grouped in different ways. For example, this repository contains the folder `experiments/`, as well as `experiments_ft_waveforms/`, `experiments_pt_waveforms/`, etc.
- default config (`default.yaml`): this is similar to an experiment config. Just like each module config offers a default, which the experiment config can overwrite, the default config can be thought of as a default experiment.


To launch an experiment use the following template:

`python -u run_train.py +experiment=<experiment_name_here>.yaml ++<module>.<module_parameter_to_override>=<value> +<module>.<module_parameter_to_add>=<value>`

As can be seen, `++` can be used to overwrite an existing module parameter, and `+` can be used to add an additional parameter, in case it is not already used.

For experiment folders with more complicated names, such as `experiments_pt_waveforms`, simply use the folder's name instead of `experiments` as such:


`python -u run_train.py +experiment_pt_model_or_any_other_folder_name=<experiment_name_here>.yaml`


### Adding new configs
A config can be added either for a new module, by creating a yaml file as described above, or for an existing module but using different parameters. For example, a model can have two configs: one for a big model and one for a smaller model. Likewise, each experiment should ideally have its own experiment config, for easier parameters tracking. Grouping these in different directories, as described above, can be done as long as the config uses global settings.

