#!/bin/bash

#SBATCH --output=path_to_output_file.out
#SBATCH --parsable
#SBATCH --nodes=2
#SBATCH --tasks-per-node=2
#SBATCH --ntasks=4
#SBATCH --time=24:00:00 
#SBATCH --cpus-per-task=2
#SBATCH --mem-per-cpu=10g
#SBATCH --gpus-per-node=rtx_4090:2

## useful command for interactive jobs stored here, but it is not used by this script
# srun --nodes=1 --tasks-per-node=1 --mem-per-cpu=10g --gpus-per-node=rtx_4090:1 --pty bash

# Send some noteworthy information to the output log
echo "Running on node: $(hostname)"
echo "In directory:    $(pwd)"
echo "Starting on:     $(date)"
echo "SLURM_JOB_ID:    ${SLURM_JOB_ID}"

nvidia-smi

# cluster environment commands (e.g. loading modules and environment)
module load gcc/8.2.0 
source ~/miniconda3/etc/profile.d/conda.sh
conda activate train_env

srun python -u run_train.py +experiment=local/path/to/experiment_name ++seed=100 ++num_nodes=2 ++pretrained_checkpoint="path/to/best.ckpt"
#e.g. +experiment=pretraining/base or exp_tuab/base or exp_neonate/exp_neonate_folds_large/neonate_fold1

