
from pytorch_lightning.callbacks.model_checkpoint import ModelCheckpoint
from typing import Optional
import os
import os.path as osp


def find_last_checkpoint_path(checkpoint_dir: Optional[str]) -> Optional[str]:
    if checkpoint_dir is None:
        return None
    checkpoint_file_name = (
        f"{ModelCheckpoint.CHECKPOINT_NAME_LAST}{ModelCheckpoint.FILE_EXTENSION}"
    )
    last_checkpoint_filepath = os.path.join(checkpoint_dir, checkpoint_file_name)
    if not osp.exists(last_checkpoint_filepath):
        return None

    return last_checkpoint_filepath