#!/bin/bash

#SBATCH  --output=/cluster/work/cvl/eeg_foundation/datasets/TUH_5h/neonate.out
#SBATCH  --time=48:00:00        
#SBATCH  --gpus=0
#SBATCH  --cpus-per-task=5
#SBATCH  --mem-per-cpu=10g


# Send some noteworthy information to the output log
echo "Running on node: $(hostname)"
echo "In directory:    $(pwd)"
echo "Starting on:     $(date)"
echo "SLURM_JOB_ID:    ${SLURM_JOB_ID}"


source ~/miniconda3/etc/profile.d/conda.sh
conda activate timefmcu11
# Print the Python interpreter path to ensure it's correct
# echo "Using Python interpreter: $(which python)"
# Run Python script using the Conda environment's Python interpreter
# python datasets/convert_edf_to_h5.py '/cluster/work/cvl/eeg_foundation/' '/TUH_Raw_Datasets/' '/TUH_sliced_datasets/' 

# python make_datasets/convert_edf_to_h5.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUAR/v3.0.1" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUAR/TUAR_v3_0_1.h5" 

# python make_datasets/convert_edf_to_h5.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUEV/edf/train" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUEV/train.h5"

# python make_datasets/convert_edf_to_h5.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUAR/v3.0.1" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUAR/le_files.h5" 

# python make_datasets/convert_edf_to_h5.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUEP/" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUEP/le_files.h5"

# python make_datasets/convert_edf_to_h5.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUSL/" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUSL/le_files.h5"

# python make_datasets/convert_edf_to_h5.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUSZ/edf/dev" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUSZ/le_files.h5"


# python make_datasets/convert_edf_to_h5.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUSZ/edf/train" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUSZ/le_files.h5"

# python make_datasets/make_tuab.py \
#     --in_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_Raw_Datasets/TUAB/edf/train" \
#     --hdf5_file_path="/cluster/work/cvl/eeg_foundation/datasets/TUH_h5/TUAB_250Hz/train_and_dev.h5" 

# python /cluster/work/cvl/eeg_foundation/datasets/TUH_h5/shuffle_dataset.py

# python datasets/concatenate_neonate.py
# python make_datasets/create_neonate_folds.py