import h5py
from tqdm import tqdm


def count_hdf5_data_samples(hdf5_file_paths):
    '''
    hdf5_file_paths: path to hdf5 files (list)
    '''
    hdf5_file_paths = []
    total_count = 0
    for file in hdf5_file_paths:
        counts = 0
        with h5py.File(file, 'r') as f:
            for k in tqdm(f.keys()):
                gr = f[k]['X']
                counts+= gr.shape[0]
                
        total_count += counts
        print(f'{file}:, {counts}') 
    print('total count across dataset:', total_count)
    print('total count in hours:', total_count*5/60/60)
