import os
import getpass
import yaml

def setup_environment(config_file='environment.yaml'):
    # Load the config from the YAML file
    with open(config_file, 'r') as file:
        config = yaml.safe_load(file)

    # Get the current username and hostname
    username = getpass.getuser()
    hostname = os.uname().nodename

    if 'leonardo' in hostname:
        hostname = 'leonardo'
    elif 'hybrida01' in hostname:
        hostname = 'hybrida01'
    else:
        # Extract the name of the host from the hostname
        # The hostname looks like for example vilan1.ee.ethz.ch or sassauna1.ee.ethz.ch or sassauna2.ee.ethz.ch
        # We need to extracr the name of the host, which is the part before the first dot
        hostname = hostname.split('.')[0]

    # Check if the hostname exists in the config
    if hostname in config:
        # Check if the username exists under the hostname
        if username in config[hostname]:
            user_config = config[hostname][username]
            data_path = user_config.get('data_path', 'MISSING')
            checkpoint_dir = user_config.get('checkpoint_dir', 'MISSING')

            # Check if any value is set to MISSING
            if data_path == 'MISSING' or checkpoint_dir == 'MISSING':
                raise ValueError(
                    f"Configuration for user '{username}' on host '{hostname}' is incomplete. "
                    f"Please update the config file: {config_file}"
                )
            
            # Set environment variables
            os.environ['DATA_PATH'] = data_path
            os.environ['CHECKPOINT_DIR'] = checkpoint_dir
        else:
            raise KeyError(f"User '{username}' not found in configuration for host '{hostname}'.")
    else:
        raise KeyError(f"Hostname '{hostname}' not found in configuration.")

    # Specific setup for mothim
    if 'mothim' in hostname:
        os.environ['CUDA_VISIBLE_DEVICES'] = '2,3,4'

    print(f"DATA_PATH set to: {os.environ['DATA_PATH']}")
    print(f"CHECKPOINT_DIR set to: {os.environ['CHECKPOINT_DIR']}")
    