import pulp

def runLP(N, rho) :
    ########################################
    # START OF LP MODEL
    ########################################
    model = pulp.LpProblem('ub', pulp.LpMaximize)

    tlist = [t for t in range(1, N+1)]
    x = pulp.LpVariable.dicts('x', tlist, lowBound=0, upBound=1)
    xbar = pulp.LpVariable.dicts('xbar', tlist, lowBound=0, upBound=1)
    d = pulp.LpVariable.dicts('d', tlist, lowBound=0, upBound=1)
    dbar = pulp.LpVariable.dicts('dbar', tlist, lowBound=0, upBound=1)

    tilist = [(t, i) for t in range(1, N+1) for i in range(t, N+1)]
    y = pulp.LpVariable.dicts('y', tilist, lowBound=0, upBound=1)
    l = pulp.LpVariable.dicts('l', tilist, lowBound=0, upBound=1)

    chi = pulp.LpVariable('chi')

    ########################################
    # objective func
    ########################################
    model += chi

    ########################################
    # constraints for the first half
    ########################################
    # degree const for online
    for t in range(1, N+1) :
        model += x[t] + (2*N - 2*t + 1) * xbar[t] <= 1, 'ondeg%03d' % t

    # d & dbar definition
    model += d[1] == x[1]
    model += dbar[1] == xbar[1]
    for t in range(2, N+1) :
        model += d[t] == dbar[t-1] + x[t]
        model += dbar[t] == dbar[t-1] + xbar[t]

    # d monotone
    for t in range(1, N) :
        model += d[t] <= d[t+1], 'dmon%03d' % t

    ########################################
    # constraints for the second half
    ########################################
    # degree const for online
    ysum = [None for _ in range(N+1)]
    for t in range(1, N+1) :
        ysum[t] = pulp.lpSum([y[(t, i)] for i in range(t, N+1)])
        model += ysum[t] <= 1

    # l definition & monotone
    for i in range(1, N+1) :
        model += l[(1, i)] == d[i] + y[(1, i)]
    for i in range(1, N) :
        model += l[(1, i)] <= l[(1, i+1)], 'lmon%03d%03d' % (1, i)
    for t in range(2, N+1) :
        for i in range(t, N+1) :
            model += l[(t, i)] == l[(t - 1, i)] + y[(t, i)]
        for i in range(t, N) :
            model += l[(t, i)] <= l[(t, i+1)], 'lmon%03d%03d' % (t, i)

    ########################################
    # constraints for robustness & consistency
    ########################################
    model += pulp.lpSum([d[t] for t in range(1, N+1)]) + N >= 2 * N * chi
    model += pulp.lpSum([d[t] + dbar[t] + ysum[t] for t in range(1, N+1)]) >= 2 * N * rho

    ########################################
    # END OF LP MODEL
    ########################################
    # model.solve(pulp.PULP_CBC_CMD(msg=False))
    model.solve(pulp.GUROBI_CMD(msg=False))

    if model.status != 1 :
        return None
    else :
        return pulp.value(model.objective)

import numpy as np

N = 1000
rholist = list(np.linspace(0.5, 1-np.exp(-1), 100))
# rholist = []
rholist += [0.5, 0.525, 0.55, 0.575, 0.6, 0.625, 1-np.exp(-1)]
chilist = list()
for rho in rholist:
    chilist.append(runLP(N, rho))
    print('%f done' % rho)

outfile = open('uwub.txt', 'w')

for i in range(len(rholist)):
    outfile.write('%f\t%f\n' % (rholist[i], chilist[i]))

outfile.close()