from library.examples.mpi_faust.preprocess_faust import preprocess_faust

# The FAUST-data set has to be downloaded from: https://faust-leaderboard.is.tuebingen.mpg.de/
# TODO: Enter the path where you have unzipped the FAUST-data set. E.g. "/home/user/MPI-FAUST"
UNZIPPED_FAUST_FOLDER = ""

# Path configuration
PREPROCESS_TARGET_DIR = "./preprocessed_faust_data"
FAUST_REGISTRATIONS_FOLDER_PATH = f"{UNZIPPED_FAUST_FOLDER}/training/registrations"
REFERENCE_MESH_PATH = f"{UNZIPPED_FAUST_FOLDER}/training/registrations/tr_reg_000.ply"


if __name__ == "__main__":
    # Start preprocess
    kernel_radius = preprocess_faust(
        n_radial=5,
        n_angular=8,
        target_dir=PREPROCESS_TARGET_DIR,
        registration_path=FAUST_REGISTRATIONS_FOLDER_PATH,
        shot=True
    )
