## Note

The code was tested using **Python 3.10.11**.

## Installation
1. Install **[BLAS](https://netlib.org/blas/#_reference_blas_version_3_10_0)** and **[CBLAS](https://netlib.org/blas/#_cblas)**:
     ```bash
     sudo apt install libatlas-base-dev
     ```
2. Install the library via:
     ```bash
     cd ./library
     pip install -r requirements.txt
     pip install .
     ```
   
3. (Optional but recommended) Make Tensorflow use a GPU (compare https://www.tensorflow.org/install/pip):
   ```bash
   conda install -c conda-forge cudatoolkit=11.8.0
   python3 -m pip install nvidia-cudnn-cu11==8.6.0.163
   mkdir -p $CONDA_PREFIX/etc/conda/activate.d
   echo 'CUDNN_PATH=$(dirname $(python -c "import nvidia.cudnn;print(nvidia.cudnn.__file__)"))' >> $CONDA_PREFIX/etc/conda/activate.d/env_vars.sh
   echo 'export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$CONDA_PREFIX/lib/:$CUDNN_PATH/lib' >> $CONDA_PREFIX/etc/conda/activate.d/env_vars.sh
   source $CONDA_PREFIX/etc/conda/activate.d/env_vars.sh
   ```
4. In case `libdevice` cannot be found:
    ```bash
    echo 'export XLA_FLAGS=--xla_gpu_cuda_data_dir=$(dirname $(find / -type d -name nvvm 2>/dev/null))' >> $CONDA_PREFIX/etc/conda/activate.d/env_vars.sh
    echo 'export TF_FORCE_GPU_ALLOW_GROWTH=true' >> $CONDA_PREFIX/etc/conda/activate.d/env_vars.sh
    source $CONDA_PREFIX/etc/conda/activate.d/env_vars.sh
    ```

## Reproducing the paper experiment results:

0. Create a Conda-environment
1. Install the library as described above into your Conda-environment
2. Install https://github.com/uhlmanngroup/pyshot  into your Conda-environment
3. Download the FAUST-dataset from https://faust-leaderboard.is.tuebingen.mpg.de/
4. Unzip the downloaded dataset.
5. Set the "UNZIPPED_FAUST_FOLDER"-path in "./experiment_scripts/preprocess_data"
6. Preprocess the FAUST-dataset by executing the "./experiment_scripts/preprocess_data.py"-script
7. Execute any experiment of interest in the "./experiment_scripts"-folder (e.g. "python ./experiment_scripts/train_dirac.py")