from distutils.core import setup, Extension
from setuptools import find_packages

import numpy as np

c_extension = Extension(
    "c_extension",
    ["./library/preprocessing/c_extension/c_extension.c"],
    include_dirs=[np.get_include()],
    extra_link_args=["-lblas", "-lcblas"]
)

if __name__ == "__main__":

    setup(
        author="Anonymized",
        name="library",
        version="1.0.0",
        packages=find_packages(),
        license="GNU General Public License v3.0",
        description="A library that implements intrinsic surface convolutions.",
        long_description=open("README.md").read(),
        url="Anonymized",
        ext_modules=[c_extension]
    )
