import torch
import torch.nn as nn

class SimpleLinear(nn.Module):
    def __init__(self, dim):
        super(SimpleLinear, self).__init__()

        self.w = nn.Parameter(torch.randn(dim))
        self.b = nn.Parameter(torch.randn(1))

    def norm(self):
        return (self.w ** 2).sum()

    def forward(self, x):
        preds = (self.w[None,:] * x).sum(dim=1) + self.b[None,:]

        return preds

    def loss(self, x, y):
        preds = self.forward(x)

        errors = torch.exp(-1 * y * preds)
        loss = errors.mean()

        return loss
    
    def log_loss(self, x, y, reg):
        loss = self.loss(x,y)
        loss = torch.log(loss)

        loss += reg * (self.w ** 2).sum()

        return loss
