from gen_data import generate_data
from seed import set_seed
import torch
from tqdm import tqdm
import pickle
from gen_data import solve_all_lp, generate_data

samples = []
T = 1000
dim = 100
CP = 3
con_num = 50
device = 'cuda' if torch.cuda.is_available() else 'cpu'

for i in tqdm(range(10)):
    set_seed(i+1010)  
    A, b, c_all, c_mean_list, split_points = generate_data(T, dim, CP, con_num=con_num, seed=i+1010)
    bounds = [(0, None)] * dim  
    x_all, f_all, lambda_all, mu_all = solve_all_lp(c_all, A, b, bounds)

    samples.append({
        "A": A,
        "b": b,
        "c_all": c_all,
        "x_all": x_all,
        "f_all": f_all,
        "split_points": split_points,
        "c_mean_list": c_mean_list,
    })

with open('test_dataset_01.pkl', 'wb') as f:
    pickle.dump(samples, f)


