from gurobipy import Model, GRB
import numpy as np

def solve_ilp(A, b, c):
    A = np.array(A)
    b = np.array(b)
    c = np.array(c)

    m_dim, n_dim = A.shape
    m = Model()
    m.setParam('OutputFlag', 0)
    m.setParam('MIPGap', 0)  
    # 24 core
    m.setParam('Threads', 96)

    x_vars = [m.addVar(vtype=GRB.INTEGER, lb=0) for _ in range(n_dim)]
    m.setObjective(sum(c[k] * x_vars[k] for k in range(n_dim)), GRB.MINIMIZE)
    for row in range(m_dim):
        m.addConstr(sum(A[row][k] * x_vars[k] for k in range(n_dim)) <= b[row])

    m.optimize()

    if m.status == GRB.OPTIMAL:
        x_val = [int(x_vars[k].X) for k in range(n_dim)]
        return m.objVal, x_val
    else:
        raise RuntimeError("Failed to find an optimal solution.")
