def evaluation_pvqrr(instances):
    Self_Direction_Thought = 0
    Self_Direction_Action = 0
    Stimulation = 0
    Hedonism = 0
    Achievement = 0
    Power_Dominance = 0
    Power_Resources = 0
    Face = 0
    Security_Personal = 0
    Security_Societal = 0
    Tradition = 0
    Conformity_Rules = 0
    Conformity_Interpersonal = 0
    Humility = 0
    Benevolence_Care = 0
    Benevolence_Dependability = 0
    Universalism_Nature = 0
    Universalism_Concern = 0
    Universalism_Tolerance = 0
    
    value_items = {
        'Self_Direction_Thought': [1, 23, 39],
        'Self_Direction_Action': [16, 30, 56],
        'Stimulation': [6, 24, 42],
        'Hedonism': [10, 27, 51],
        'Achievement': [5, 28, 46],
        'Power_Dominance': [12, 29, 45],
        'Power_Resources': [20, 32, 49],
        'Face': [8, 25, 43],
        'Security_Personal': [13, 26, 53],
        'Security_Societal': [2, 35, 50],
        'Tradition': [18, 33, 40],
        'Conformity_Rules': [3, 21, 36],
        'Conformity_Interpersonal': [7, 19, 47],
        'Humility': [11, 22, 41],
        'Benevolence_Care': [14, 34, 54],
        'Benevolence_Dependability': [4, 31, 55],
        'Universalism_Nature': [9, 37, 52],
        'Universalism_Concern': [17, 38, 57],
        'Universalism_Tolerance': [15, 44, 48]
    }
    
    for idx, inst in enumerate(instances):
        question_id = int(inst['question_id'])
        choice = inst['respond_answer']
        score = 0
        
        if choice == "A":
            score = 0
        elif choice == "B":
            score = 1
        elif choice == "C":
            score = 2
        elif choice == "D":
            score = 3
        elif choice == "E":
            score = 4
        elif choice == "F":
            score = 5
        
        for value_name, question_ids in value_items.items():
            if question_id in question_ids:
                if value_name == 'Self_Direction_Thought':
                    Self_Direction_Thought += score
                elif value_name == 'Self_Direction_Action':
                    Self_Direction_Action += score
                elif value_name == 'Stimulation':
                    Stimulation += score
                elif value_name == 'Hedonism':
                    Hedonism += score
                elif value_name == 'Achievement':
                    Achievement += score
                elif value_name == 'Power_Dominance':
                    Power_Dominance += score
                elif value_name == 'Power_Resources':
                    Power_Resources += score
                elif value_name == 'Face':
                    Face += score
                elif value_name == 'Security_Personal':
                    Security_Personal += score
                elif value_name == 'Security_Societal':
                    Security_Societal += score
                elif value_name == 'Tradition':
                    Tradition += score
                elif value_name == 'Conformity_Rules':
                    Conformity_Rules += score
                elif value_name == 'Conformity_Interpersonal':
                    Conformity_Interpersonal += score
                elif value_name == 'Humility':
                    Humility += score
                elif value_name == 'Benevolence_Care':
                    Benevolence_Care += score
                elif value_name == 'Benevolence_Dependability':
                    Benevolence_Dependability += score
                elif value_name == 'Universalism_Nature':
                    Universalism_Nature += score
                elif value_name == 'Universalism_Concern':
                    Universalism_Concern += score
                elif value_name == 'Universalism_Tolerance':
                    Universalism_Tolerance += score
                break
    
    level3 = {
        "Self_Direction_Thought": Self_Direction_Thought,
        "Self_Direction_Action": Self_Direction_Action,
        "Stimulation": Stimulation,
        "Hedonism": Hedonism,
        "Achievement": Achievement,
        "Power_Dominance": Power_Dominance,
        "Power_Resources": Power_Resources,
        "Face": Face,
        "Security_Personal": Security_Personal,
        "Security_Societal": Security_Societal,
        "Tradition": Tradition,
        "Conformity_Rules": Conformity_Rules,
        "Conformity_Interpersonal": Conformity_Interpersonal,
        "Humility": Humility,
        "Benevolence_Care": Benevolence_Care,
        "Benevolence_Dependability": Benevolence_Dependability,
        "Universalism_Nature": Universalism_Nature,
        "Universalism_Concern": Universalism_Concern,
        "Universalism_Tolerance": Universalism_Tolerance
    }
    
    Self_Direction = Self_Direction_Thought + Self_Direction_Action
    Power = Power_Dominance + Power_Resources
    Security = Security_Personal + Security_Societal
    Conformity = Conformity_Rules + Conformity_Interpersonal
    Benevolence = Benevolence_Care + Benevolence_Dependability
    Universalism = Universalism_Nature + Universalism_Concern + Universalism_Tolerance
    
    level2 = {
        "Self_Direction": Self_Direction,
        "Stimulation": Stimulation,
        "Hedonism": Hedonism,
        "Achievement": Achievement,
        "Power": Power,
        "Security": Security,
        "Conformity": Conformity,
        "Tradition": Tradition,
        "Benevolence": Benevolence,
        "Universalism": Universalism
    }
    
    Self_Transcendence = Universalism + Benevolence
    Self_Enhancement = Achievement + Power
    Openness_to_Change = Self_Direction + Stimulation + Hedonism
    Conservation = Security + Tradition + Conformity
    
    level1 = {
        "Self_Transcendence": Self_Transcendence,
        "Self_Enhancement": Self_Enhancement,
        "Openness_to_Change": Openness_to_Change,
        "Conservation": Conservation
    }
    
    return {
        "level1": level1,
        "level2": level2,
        "level3": level3
    }