#%%
from typing import Dict, Union
import random

import pandas as pd

import warnings
warnings.filterwarnings('ignore', category=FutureWarning)
#%%
def tab2text(
    missing: pd.DataFrame, 
    idx: Union[int, slice, str],
    permutation=False) -> Dict:
    """Get Item from Tabular Data
    
    Get one instance of the tabular data, permuted (option), converted to text and tokenized.
    """

    if isinstance(idx, int):
        row = missing.iloc[idx]
    else:
        row = missing.loc[idx]
    

    key = list(range(len(row)))

    if permutation:
        random.shuffle(key) 

    text = ", ".join(
        [
            "%s is %s" % (row.index[i], str(row[i]).strip())
            for i in key
        ]
    )

    return text
#%%
def reformat(data):
    return ', '.join(f"{key} is {value}" for key, value in data.items())