# %%
from collections import namedtuple
from evaluation import metrics_impute, metrics_MLu

import warnings
warnings.filterwarnings("ignore", "use_inf_as_na")
#%%
Metrics = namedtuple(
    "Metrics",
    [   
        "smape",
        "error",
        "arsmape",
        "base_cls", 
        "syn_cls",
        "model_selection", 
        "feature_selection",
    ]
)
#%%
def evaluate(imputed, train_dataset, test_dataset, config, device):
    
    print("\n1. Element-wise: ARSMAPE...")
    smape, error = metrics_impute.SMAPE(train_dataset, imputed)
    arsmape = smape + error
    
    print("\n2. Machine Learning Utility: Classification...")
    base_cls, syn_cls, model_selection, feature_selection = metrics_MLu.MLu_cls(train_dataset, test_dataset, imputed)
    
    

    return Metrics(
        smape, error, arsmape,
        base_cls, syn_cls, model_selection, feature_selection,
    )