/*
 * Decompiled with CFR 0.152.
 */
import agents.robinBaumgarten.Agent;
import engine.core.MarioGame;
import engine.core.MarioResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class PlayLevel {
    public static void printResults(MarioResult result) {
        System.out.println("****************************************************************");
        System.out.println("Game Status: " + result.getGameStatus().toString() + " Percentage Completion: " + result.getCompletionPercentage());
        System.out.println("Lives: " + result.getCurrentLives() + " Coins: " + result.getCurrentCoins() + " Remaining Time: " + (int)Math.ceil((float)result.getRemainingTime() / 1000.0f));
        System.out.println("Mario State: " + result.getMarioMode() + " (Mushrooms: " + result.getNumCollectedMushrooms() + " Fire Flowers: " + result.getNumCollectedFireflower() + ")");
        System.out.println("Total Kills: " + result.getKillsTotal() + " (Stomps: " + result.getKillsByStomp() + " Fireballs: " + result.getKillsByFire() + " Shells: " + result.getKillsByShell() + " Falls: " + result.getKillsByFall() + ")");
        System.out.println("Bricks: " + result.getNumDestroyedBricks() + " Jumps: " + result.getNumJumps() + " Max X Jump: " + result.getMaxXJump() + " Max Air Time: " + result.getMaxJumpAirTime());
        System.out.println("****************************************************************");
    }

    public static String getLevel(String filepath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(filepath, new String[0])));
        }
        catch (IOException e) {
            System.out.println("Cannot open " + filepath);
        }
        return content;
    }

    public static void main(String[] args) {
        String id = "lvl-1";
        MarioGame game = new MarioGame();
        game.setVerbose(true);
        Agent agent = new Agent();
        game.runGame(agent, PlayLevel.getLevel("levels/video_levels/collector.txt"), 200, 0, true, 18, 1.0f);
    }
}

