/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;
import agents.andySloane.WorldState;

public final class BulletBillState
extends SpriteState {
    public static final float width = 4.0f;

    @Override
    public final float height() {
        return 12.0f;
    }

    @Override
    public final boolean dead() {
        return this.deadTime != 0;
    }

    @Override
    public SpriteState clone() {
        BulletBillState e = new BulletBillState(this.x, this.y, this.facing);
        e.xa = this.xa;
        e.ya = this.ya;
        e.facing = this.facing;
        e.deadTime = this.deadTime;
        return e;
    }

    BulletBillState(float _x, float _y, int dir) {
        this.x = _x;
        this.y = _y;
        this.type = 8;
        this.facing = dir;
        this.xa = 4 * this.facing;
    }

    BulletBillState(float _x, float _y, MarioState ms) {
        this.x = _x;
        this.y = _y;
        this.type = 8;
        this.facing = _x < ms.x ? 1 : -1;
        this.xa = 4 * this.facing;
    }

    @Override
    public boolean move(WorldState ws) {
        if (this.deadTime > 0) {
            --this.deadTime;
            if (this.deadTime == 0) {
                this.deadTime = 1;
                return false;
            }
            this.x += this.xa;
            this.y += this.ya;
            this.ya = (float)((double)this.ya * 0.95);
            this.ya += 1.0f;
            return true;
        }
        float sideWaysSpeed = 4.0f;
        this.xa = (float)this.facing * sideWaysSpeed;
        this.x += this.xa;
        return true;
    }

    @Override
    public SpriteState stomp(WorldState ws, MarioState ms) {
        BulletBillState e = (BulletBillState)this.clone();
        e.xa = 0.0f;
        e.ya = 1.0f;
        e.deadTime = 100;
        return e;
    }

    @Override
    public WorldState collideCheck(WorldState ws, MarioState ms) {
        if (this.deadTime != 0) {
            return ws;
        }
        float xMarioD = ms.x - this.x;
        float yMarioD = ms.y - this.y;
        if (xMarioD > -16.0f && xMarioD < 16.0f && yMarioD > -this.height() && yMarioD < ms.height()) {
            if (ms.ya > 0.0f && yMarioD <= 0.0f && (!ms.onGround || !ms.wasOnGround)) {
                ws = ws.stomp(this, ms);
            } else {
                ms.getHurt();
            }
        }
        return ws;
    }
}

