/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;
import agents.andySloane.WorldState;

public class EnemyState
extends SpriteState {
    public boolean flyDeath = false;
    public static final float width = 4.0f;

    @Override
    public final float height() {
        return this.type >= 4 && this.type <= 7 ? 24.0f : 12.0f;
    }

    @Override
    public SpriteState clone() {
        EnemyState e = new EnemyState(this.x, this.y, this.type);
        e.xa = this.xa;
        e.ya = this.ya;
        e.facing = this.facing;
        e.deadTime = this.deadTime;
        e.flyDeath = this.flyDeath;
        e.onGround = this.onGround;
        return e;
    }

    public final boolean avoidCliffs() {
        return this.type == 4;
    }

    public final boolean winged() {
        switch (this.type) {
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean spiky() {
        switch (this.type) {
            case 9: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public final boolean noFireballDeath() {
        switch (this.type) {
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean dead() {
        return this.deadTime != 0;
    }

    EnemyState(float _x, float _y, int _type) {
        this.x = _x;
        this.y = _y;
        this.type = _type;
        this.ya = this.winged() ? 0.6f : 2.0f;
        this.facing = -1;
    }

    @Override
    public boolean move(WorldState ws) {
        if (this.deadTime > 0) {
            --this.deadTime;
            if (this.deadTime == 0) {
                this.deadTime = 1;
                return false;
            }
            if (this.flyDeath) {
                this.x += this.xa;
                this.y += this.ya;
                this.ya = (float)((double)this.ya * 0.95);
                this.ya += 1.0f;
            }
            return true;
        }
        float sideWaysSpeed = 1.75f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        } else if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * sideWaysSpeed;
        if (!this.move(this.xa, 0.0f, ws)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya, ws);
        this.ya *= this.winged() ? 0.95f : 0.85f;
        this.xa *= 0.89f;
        if (!this.onGround) {
            this.ya = this.winged() ? (this.ya += 0.6f) : (this.ya += 2.0f);
        } else if (this.winged()) {
            this.ya = -10.0f;
        }
        return true;
    }

    @Override
    public void resync(float x, float y, float prev_x, float prev_y) {
        this.x = x;
        this.y = y;
        this.xa = x - prev_x;
        if (this.xa == 0.0f) {
            this.deadTime = 9;
            return;
        }
        this.facing = this.xa < 0.0f ? -1 : 1;
        this.ya = (y - prev_y) * (this.winged() ? 0.95f : 0.85f);
        if (this.xa == 0.0f || this.ya == 0.0f) {
            // empty if block
        }
        if (!this.onGround) {
            this.ya = this.winged() ? (this.ya += 0.6f) : (this.ya += 2.0f);
        } else if (this.winged()) {
            this.ya = -10.0f;
        }
    }

    private boolean move(float xa, float ya, WorldState ws) {
        float height = this.height();
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f, ws)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f, ws)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f, ws)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f, ws)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya, xa, 0.0f, ws)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + 4.0f, this.y + ya, xa, 0.0f, ws)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - 4.0f, this.y + ya + 1.0f, xa, ya, ws)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + 4.0f, this.y + ya + 1.0f, xa, ya, ws)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - height, xa, ya, ws)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - 4.0f, this.y + ya - height, xa, ya, ws)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + 4.0f, this.y + ya - height, xa, ya, ws)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            if (this.isBlocking(this.x + xa + 4.0f, this.y + ya - height, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + 4.0f, this.y + ya - height / 2.0f, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + 4.0f, this.y + ya, xa, ya, ws)) {
                collide = true;
            }
            if (this.avoidCliffs() && this.onGround && !ws.isBlocking((int)((this.x + xa + 4.0f) / 16.0f), (int)(this.y / 16.0f + 1.0f), xa, 1.0f)) {
                collide = true;
            }
        }
        if (xa < 0.0f) {
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya - height, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya - height / 2.0f, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya, xa, ya, ws)) {
                collide = true;
            }
            if (this.avoidCliffs() && this.onGround && !ws.isBlocking((int)((this.x + xa - 4.0f) / 16.0f), (int)(this.y / 16.0f + 1.0f), xa, 1.0f)) {
                collide = true;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (float)((int)((this.x - 4.0f) / 16.0f) * 16) + 4.0f;
                this.xa = 0.0f;
            }
            if (xa > 0.0f) {
                this.x = (float)((int)((this.x + 4.0f) / 16.0f + 1.0f) * 16) - 4.0f - 1.0f;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (float)((int)((this.y - height) / 16.0f) * 16) + height;
                this.ya = 0.0f;
            }
            if (ya > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya, WorldState ws) {
        int x = (int)(_x / 16.0f);
        int y = (int)(_y / 16.0f);
        if (x == (int)(this.x / 16.0f) && y == (int)(this.y / 16.0f)) {
            return false;
        }
        return ws.isBlocking(x, y, xa, ya);
    }

    @Override
    public SpriteState stomp(WorldState ws, MarioState ms) {
        EnemyState e = (EnemyState)this.clone();
        if (e.winged()) {
            --e.type;
            e.ya = 0.0f;
        } else {
            e.deadTime = 10;
            if (this.type == 4 || this.type == 6) {
                ws.addShell(this.x, this.y);
            }
        }
        return e;
    }

    @Override
    public WorldState collideCheck(WorldState ws, MarioState ms) {
        if (this.deadTime != 0) {
            return ws;
        }
        float xMarioD = ms.x - this.x;
        float yMarioD = ms.y - this.y;
        float height = this.height();
        if (xMarioD > -12.0f && xMarioD < 12.0f && yMarioD > -height && yMarioD < ms.height()) {
            if (!(this.spiky() || !(ms.ya > 0.0f) || !(yMarioD <= 0.0f) || ms.onGround && ms.wasOnGround)) {
                ws = ws.stomp(this, ms);
            } else {
                ms.getHurt();
            }
        }
        return ws;
    }
}

