/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioMath;
import agents.andySloane.MarioState;
import agents.andySloane.MarioStateComparator;
import agents.andySloane.Sensors;
import agents.andySloane.Tunables;
import agents.andySloane.WorldState;
import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;
import java.util.Comparator;

public abstract class HeuristicSearchingAgent
implements MarioAgent {
    public static final Comparator<MarioState> msComparator = new MarioStateComparator();
    protected final boolean[] action = new boolean[MarioActions.numberOfActions()];
    protected int[] marioPosition = null;
    protected Sensors sensors = new Sensors();
    protected static final boolean stdinSingleStep = false;
    MarioState ms = null;
    MarioState ms_prev = null;
    WorldState ws = null;
    float pred_x;
    float pred_y;
    boolean won = false;

    protected final float cost(MarioState s, MarioState initial) {
        float damage = Tunables.HurtCost * (float)s.hurt;
        if (s.dead) {
            return Tunables.DeadCost;
        }
        int MarioX = (int)s.x / 16 - s.ws.MapX;
        int MarioY = (int)s.y / 16 - s.ws.MapY;
        int goal = 15;
        float fgoalX = (goal + s.ws.MapX) * 16 + 8;
        if (s.x > fgoalX) {
            return (fgoalX - s.x) / 9.71f;
        }
        float xsteps = MarioMath.stepsToRun(fgoalX - s.x, s.xa);
        if (MarioX < 0 || MarioX >= 22) {
            return xsteps + damage;
        }
        int ledgeY = 22;
        int ledgeX = MarioX;
        for (int i = MarioX; i <= goal; ++i) {
            if (s.ws.heightmap[i] >= ledgeY) continue;
            ledgeY = s.ws.heightmap[i];
            ledgeX = i;
        }
        float fLedgeY = (ledgeY + s.ws.MapY) * 16 - 1;
        float fLedgeX = (ledgeX + s.ws.MapX) * 16 - 4;
        if (s.onGround) {
            if (s.y <= fLedgeY) {
                return damage + xsteps;
            }
            float sj = MarioMath.stepsToJump(s.y - fLedgeY);
            float sr1 = MarioMath.stepsToRun(fLedgeX - s.x, s.xa);
            float sr2 = MarioMath.stepsToRun(fgoalX - fLedgeX, s.xa);
            return damage + Math.max(sj, sr1) + sr2;
        }
        MarioState l = s.clone();
        MarioState r = s.clone();
        float apogeey = l.y;
        int apogeesteps = 0;
        int stepsR = 0;
        while (!l.dead && !l.onGround) {
            l.move(MarioState.ACT_SPEED | MarioState.ACT_LEFT | MarioState.ACT_JUMP);
        }
        while (!r.dead && !r.onGround) {
            r.move(MarioState.ACT_SPEED | MarioState.ACT_RIGHT | MarioState.ACT_JUMP);
            ++stepsR;
            if (!(r.y <= apogeey)) continue;
            apogeey = r.y;
            apogeesteps = stepsR;
        }
        if (r.dead && l.dead) {
            return Tunables.DeadCost;
        }
        if (MarioMath.canReachLedge(s.x, s.xa, apogeesteps, apogeey, fLedgeX, fLedgeY)) {
            return damage + xsteps;
        }
        int perchY = 22;
        for (float i = l.x; i <= r.x; i += 16.0f) {
            int idx = (int)i / 16 - s.ws.MapX;
            if (idx < 0 || idx >= 16 || s.ws.heightmap[idx] >= perchY || s.ws.heightmap[idx] < MarioY) continue;
            perchY = s.ws.heightmap[idx];
        }
        float landy = (perchY + s.ws.MapY) * 16 - 1;
        float sf = 0.0f;
        float sj = MarioMath.stepsToJump(fLedgeY - landy);
        float sr1 = MarioMath.stepsToRun(fLedgeX - s.x, s.xa);
        float sr2 = MarioMath.stepsToRun(fgoalX - fLedgeX, s.xa);
        return damage + Math.max(sf + sj, sr1) + sr2;
    }

    public static final boolean useless_action(int a, MarioState s) {
        if ((a & MarioState.ACT_SPEED) > 0 && (a & MarioState.ACT_LEFT) <= 0 && (a & MarioState.ACT_RIGHT) <= 0) {
            return true;
        }
        if ((a & MarioState.ACT_LEFT) > 0 && (a & MarioState.ACT_RIGHT) > 0) {
            return true;
        }
        if ((a & MarioState.ACT_JUMP) > 0) {
            if (s.jumpTime == 0 && !s.mayJump) {
                return true;
            }
            if (s.jumpTime <= 0 && !s.onGround && !s.sliding) {
                return true;
            }
        }
        int ix = (int)s.x;
        if ((a & MarioState.ACT_RIGHT) > 0 && s.xa == 0.0f && s.x - (float)ix == 0.0f && (ix & 0xF) == 11) {
            return s.ws.isBlocking((ix + 5) / 16, (int)(s.y / 16.0f), 1.0f, s.ya) || s.ws.isBlocking((ix + 5) / 16, (int)(s.y / 16.0f) - 1, 1.0f, s.ya) || s.ws.isBlocking((ix + 5) / 16, (int)(s.y / 16.0f) - 2, 1.0f, s.ya);
        }
        return false;
    }

    protected abstract int searchForAction(MarioState var1, WorldState var2);

    public static MarioState marioMin(MarioState a, MarioState b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.cost - a.g <= b.cost - b.g) {
            return a;
        }
        return b;
    }

    @Override
    public void initialize(MarioForwardModel model, MarioTimer timer) {
        this.ms = null;
        this.marioPosition = null;
        this.won = false;
    }

    @Override
    public boolean[] getActions(MarioForwardModel model, MarioTimer timer) {
        if (this.won) {
            return this.action;
        }
        this.sensors.updateReadings(model);
        this.marioPosition = this.sensors.getMarioPosition();
        float[] mpos = model.getMarioFloatPos();
        if (this.ms == null) {
            this.ms = new MarioState(mpos[0], mpos[1], 0.0f, 3.0f);
            this.ws = new WorldState(this.sensors.levelScene, this.ms, model.getEnemiesFloatPos());
        } else {
            if (!(mpos[0] == this.pred_x && mpos[1] == this.pred_y || HeuristicSearchingAgent.epsilon(mpos[0], this.pred_x) && HeuristicSearchingAgent.epsilon(mpos[1], this.pred_y) || !(mpos[0] > 4000.0f) || mpos[0] != this.ms_prev.x || mpos[1] != this.ms_prev.y)) {
                this.won = true;
                return this.action;
            }
            this.resync(model, !HeuristicSearchingAgent.epsilon(mpos[0], this.pred_x), !HeuristicSearchingAgent.epsilon(mpos[1], this.pred_y));
            this.ms.ws.sync(this.ws, this.sensors.levelScene, this.ms, model.getEnemiesFloatPos());
            this.ws = this.ms.ws;
        }
        this.ms.mayJump = model.mayMarioJump();
        this.ms.onGround = model.isMarioOnGround();
        this.ms.big = model.getMarioMode() > 0;
        int next_action = this.searchForAction(this.ms, this.ws);
        this.ms_prev = this.ms;
        this.ms = this.ms.next(next_action, this.ws);
        this.pred_x = this.ms.x;
        this.pred_y = this.ms.y;
        this.action[MarioActions.SPEED.getValue()] = (next_action & MarioState.ACT_SPEED) != 0;
        this.action[MarioActions.RIGHT.getValue()] = (next_action & MarioState.ACT_RIGHT) != 0;
        this.action[MarioActions.LEFT.getValue()] = (next_action & MarioState.ACT_LEFT) != 0;
        this.action[MarioActions.JUMP.getValue()] = (next_action & MarioState.ACT_JUMP) != 0;
        return this.action;
    }

    private static boolean epsilon(float a, float b) {
        return (double)Math.abs(a - b) < 0.01;
    }

    private void resync(MarioForwardModel model, boolean x, boolean y) {
        float[] mpos = model.getMarioFloatPos();
        this.ms.x = mpos[0];
        this.ms.y = mpos[1];
        if (this.ms_prev != null) {
            if (x) {
                this.ms.xa = (this.ms.x - this.ms_prev.x) * 0.89f;
            }
            if (y) {
                this.ms.ya = (this.ms.y - this.ms_prev.y) * 0.85f;
            }
        }
    }

    @Override
    public String getAgentName() {
        return "AndySloaneAgent";
    }
}

